/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.myfaces.custom.tree.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import net.sourceforge.myfaces.custom.tree.HtmlTreeImageCommandLink;
import net.sourceforge.myfaces.custom.tree.HtmlTreeNode;
import net.sourceforge.myfaces.renderkit.html.HTML;
import net.sourceforge.myfaces.renderkit.html.HtmlLinkRendererBase;
import net.sourceforge.myfaces.renderkit.html.HtmlRendererUtils;

public class HtmlTreeImageCommandLinkRenderer
extends HtmlLinkRendererBase {
    private static final Integer ZERO = new Integer(0);

    public void decode(FacesContext facesContext, UIComponent component) {
        super.decode(facesContext, component);
        String clientId = component.getClientId(facesContext);
        String reqValue = (String)facesContext.getExternalContext().getRequestParameterMap().get(HtmlRendererUtils.getHiddenCommandLinkFieldName(HtmlRendererUtils.getFormName(component, facesContext)));
        if (reqValue != null && reqValue.equals(clientId)) {
            HtmlTreeNode node = (HtmlTreeNode)component.getParent();
            node.toggleExpanded();
        }
    }

    protected void renderCommandLinkStart(FacesContext facesContext, UIComponent component, String clientId, Object value, String style, String styleClass) throws IOException {
        super.renderCommandLinkStart(facesContext, component, clientId, value, style, styleClass);
        String url = ((HtmlTreeImageCommandLink)component).getImage();
        if (url != null && url.length() > 0) {
            String src;
            ResponseWriter writer = facesContext.getResponseWriter();
            writer.startElement("img", component);
            if (url.startsWith("/")) {
                String path = facesContext.getExternalContext().getRequestContextPath();
                src = path + url;
            } else {
                src = url;
            }
            src = facesContext.getExternalContext().encodeResourceURL(src);
            writer.writeAttribute("src", (Object)src, null);
            writer.writeAttribute("border", (Object)ZERO, null);
            HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.IMG_PASSTHROUGH_ATTRIBUTES);
            writer.endElement("img");
        }
    }
}

