/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.myfaces.convert;

public final class ConverterUtils {
    private ConverterUtils() {
    }

    public static int convertToInt(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cannot convert " + value.toString() + " to int");
            }
        }
        throw new IllegalArgumentException("Cannot convert " + value.toString() + " to int");
    }

    public static boolean convertToBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            try {
                return new Boolean((String)value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot convert " + value.toString() + " to boolean");
            }
        }
        throw new IllegalArgumentException("Cannot convert " + value.toString() + " to int");
    }

    public static long convertToLong(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            try {
                return Long.parseLong((String)value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cannot convert " + value.toString() + " to long");
            }
        }
        throw new IllegalArgumentException("Cannot convert " + value.toString() + " to long");
    }

    public static double convertToDouble(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cannot convert " + value.toString() + " to double");
            }
        }
        throw new IllegalArgumentException("Cannot convert " + value.toString() + " to double");
    }
}

