/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.io.DataInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.Binary;
import org.hsqldb.Column;
import org.hsqldb.HsqlException;
import org.hsqldb.JavaObject;
import org.hsqldb.lib.BooleanConverter;
import org.hsqldb.rowio.RowInputBase;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.store.ValuePool;

public class RowInputLegacy
extends RowInputBase
implements RowInputInterface {
    public int readType() throws IOException {
        return this.readInt();
    }

    public int readIntData() throws IOException {
        return this.readInt();
    }

    public String readString() throws IOException {
        return DataInputStream.readUTF(this);
    }

    private String readNumericString() throws IOException {
        return this.readString();
    }

    byte[] readByteArray() throws IOException {
        byte[] byArray = new byte[this.readInt()];
        this.readFully(byArray);
        return byArray;
    }

    protected boolean checkNull() throws IOException {
        return this.readInt() == 0;
    }

    protected String readChar(int n) throws IOException {
        return this.readUTF();
    }

    protected Integer readSmallint() throws IOException, HsqlException {
        int n = Integer.parseInt(this.readNumericString());
        return ValuePool.getInt(n);
    }

    protected Integer readInteger() throws IOException, HsqlException {
        return ValuePool.getInt(this.readInt());
    }

    protected Long readBigint() throws IOException, HsqlException {
        long l = Long.parseLong(this.readNumericString());
        return ValuePool.getLong(l);
    }

    protected Double readReal(int n) throws IOException, HsqlException {
        if (n == 7) {
            double d = new Double(this.readNumericString());
            long l = Double.doubleToLongBits(d);
            return ValuePool.getDouble(l);
        }
        long l = this.readLong();
        return ValuePool.getDouble(l);
    }

    protected BigDecimal readDecimal() throws IOException, HsqlException {
        return ValuePool.getBigDecimal(new BigDecimal(this.readNumericString()));
    }

    protected Boolean readBit() throws IOException, HsqlException {
        return BooleanConverter.getBoolean(this.readString());
    }

    protected Time readTime() throws IOException, HsqlException {
        return Time.valueOf(this.readString());
    }

    protected Date readDate() throws IOException, HsqlException {
        return Date.valueOf(this.readString());
    }

    protected Timestamp readTimestamp() throws IOException, HsqlException {
        return Timestamp.valueOf(this.readString());
    }

    protected Object readOther() throws IOException, HsqlException {
        String string = this.readString();
        byte[] byArray = string.equals("**") ? this.readByteArray() : Column.hexToByteArray(string);
        return new JavaObject(byArray);
    }

    protected Binary readBinary(int n) throws IOException, HsqlException {
        String string = this.readString();
        if (string.equals("**")) {
            return new Binary(this.readByteArray(), false);
        }
        return new Binary(Column.hexToByteArray(string), false);
    }
}

