/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dbcp.impl;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import javax.sql.XAConnection;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.seasar.extension.dbcp.ConnectionPool;
import org.seasar.extension.dbcp.ConnectionWrapper;
import org.seasar.extension.dbcp.impl.XAResourceWrapperImpl;
import org.seasar.framework.exception.SSQLException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.TransactionManagerUtil;

public final class ConnectionWrapperImpl
implements ConnectionWrapper {
    private static Logger logger_;
    private XAConnection xaConnection_;
    private Connection physicalConnection_;
    private XAResource xaResource_;
    private ConnectionPool connectionPool_;
    private TransactionManager transactionManager_;
    private boolean closed_ = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.extension.dbcp.impl.ConnectionWrapperImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
    }

    public ConnectionWrapperImpl(XAConnection xaConnection, ConnectionPool connectionPool, TransactionManager transactionManager) throws SQLException {
        this.xaConnection_ = xaConnection;
        this.physicalConnection_ = xaConnection.getConnection();
        this.xaResource_ = new XAResourceWrapperImpl(xaConnection.getXAResource(), this);
        this.connectionPool_ = connectionPool;
        this.transactionManager_ = transactionManager;
    }

    public Connection getPhysicalConnection() {
        return this.physicalConnection_;
    }

    public XAResource getXAResource() {
        return this.xaResource_;
    }

    public XAConnection getXAConnection() {
        return this.xaConnection_;
    }

    public void init() {
        this.closed_ = false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeReally() {
        if (this.xaConnection_ == null) {
            return;
        }
        this.closed_ = true;
        try {
            try {
                this.xaConnection_.close();
                logger_.log("DSSR0001", null);
            }
            catch (SQLException ex) {
                logger_.log((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.xaConnection_ = null;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.xaConnection_ = null;
        }
        {
            if (this.physicalConnection_.isClosed()) return;
            this.physicalConnection_.close();
            return;
        }
    }

    private void assertOpened() throws SQLException {
        if (this.closed_) {
            throw new SSQLException("ESSR0062", null);
        }
    }

    public void release() throws SQLException {
        this.connectionPool_.release(this);
    }

    public Statement createStatement() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.createStatement();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.prepareStatement(sql);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.prepareCall(sql);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.nativeSQL(sql);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public boolean isClosed() throws SQLException {
        return this.closed_;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.getMetaData();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.assertOpened();
        try {
            this.physicalConnection_.setReadOnly(readOnly);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public boolean isReadOnly() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.isReadOnly();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        this.assertOpened();
        try {
            this.physicalConnection_.setCatalog(catalog);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public String getCatalog() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.getCatalog();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public void close() throws SQLException {
        if (this.closed_) {
            return;
        }
        if (TransactionManagerUtil.getTransaction((TransactionManager)this.transactionManager_) != null) {
            return;
        }
        this.closed_ = true;
        this.connectionPool_.checkIn(this);
        logger_.log("DSSR0002", null);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.assertOpened();
        try {
            this.physicalConnection_.setTransactionIsolation(level);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.getTransactionIsolation();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.getWarnings();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public void clearWarnings() throws SQLException {
        this.assertOpened();
        try {
            this.physicalConnection_.clearWarnings();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public void commit() throws SQLException {
        this.assertOpened();
        try {
            this.physicalConnection_.commit();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public void rollback() throws SQLException {
        this.assertOpened();
        try {
            this.physicalConnection_.rollback();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.assertOpened();
        try {
            this.physicalConnection_.setAutoCommit(autoCommit);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.getAutoCommit();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public Map getTypeMap() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.getTypeMap();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        this.assertOpened();
        try {
            this.physicalConnection_.setTypeMap(map);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public void setHoldability(int holdability) throws SQLException {
        this.assertOpened();
        try {
            this.physicalConnection_.setHoldability(holdability);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public int getHoldability() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.getHoldability();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.setSavepoint();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.setSavepoint(name);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.assertOpened();
        try {
            this.physicalConnection_.rollback(savepoint);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.assertOpened();
        try {
            this.physicalConnection_.releaseSavepoint(savepoint);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.prepareStatement(sql, autoGeneratedKeys);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.prepareStatement(sql, columnIndexes);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.prepareStatement(sql, columnNames);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }
}

