package org.seasar.dao;

import org.seasar.framework.beans.MethodNotFoundRuntimeException;

/**
 * @author higa
 *  
 */
public interface DaoMetaData {

	public String BEAN = "BEAN";

	public String ARGS_SUFFIX = "_ARGS";

	public String QUERY_SUFFIX = "_QUERY";

	public String NO_PERSISTENT_PROPS_SUFFIX = "_NO_PERSISTENT_PROPS";

	public String PERSISTENT_PROPS_SUFFIX = "_PERSISTENT_PROPS";

	public Class getBeanClass();

	public BeanMetaData getBeanMetaData();

	public boolean hasSqlCommand(String methodName);

	public SqlCommand getSqlCommand(String methodName)
			throws MethodNotFoundRuntimeException;

	public SqlCommand createFindCommand(String query);

	public SqlCommand createFindArrayCommand(String query);

	public SqlCommand createFindBeanCommand(String query);

	public SqlCommand createFindObjectCommand(String query);
}