package org.seasar.framework.aop.interceptors;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.impl.MethodInvocationImpl;

/**
 * @author higa
 *
 */
public class InterceptorChain extends AbstractInterceptor {
    
	private MethodInterceptor[] interceptors = new MethodInterceptor[0];

    public void add(MethodInterceptor interceptor) {
        int length = interceptors.length;
        MethodInterceptor[] newArray = new MethodInterceptor[length + 1];
        System.arraycopy(interceptors, 0, newArray, 0, length);
        newArray[length] = interceptor;
        interceptors = newArray;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        MethodInvocation nestInvocation = new MethodInvocationImpl((MethodInvocationImpl) invocation,
                interceptors);
        return nestInvocation.proceed();
    }
}