/*
 * 
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or 
 * without modification, are permitted provided that the following 
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer in the documentation and/or other materials provided 
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:  
 *    "This product includes software developed by the 
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements 
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission of 
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT 
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.seasar.axis.server;

/**
 * dicont@CŃ^Cv}bsOݒ肷邽߂Ɏg܂B
 * 
 * @see ServiceDef#addTypeMapping(TypeMappingDef)
 * @author koichik
 */
public class TypeMappingDef {
    protected Class type;
    protected String localPart = "";
    protected String namespaceURI = "";
    protected String namespacePrefix = "";
    protected Class serializer;
    protected Class deserializer;
    protected String encodingStyle;

    /**
     * Java^Ԃ܂B
     * 
     * @return Returns the type.
     */
    public Class getType() {
        return type;
    }

    /**
     * Java^ݒ肵܂B
     * 
     * @param type
     *            The type to set.
     */
    public void setType(final Class type) {
        this.type = type;
    }

    /**
     * XML^̖OURIԂ܂B
     * 
     * @return Returns the namespaceURI.
     */
    public String getNamespaceURI() {
        return namespaceURI;
    }

    /**
     * XML^̖OURIݒ肵܂B
     * 
     * @param namespaceURI
     *            The namespaceURI to set.
     */
    public void setNamespaceURI(final String namespaceURI) {
        this.namespaceURI = namespaceURI;
    }

    /**
     * XML^̃[JԂ܂B
     * 
     * @return Returns the localPart.
     */
    public String getLocalPart() {
        return localPart;
    }

    /**
     * XML^̃[Jݒ肵܂B
     * 
     * @param localPart
     *            The localPart to set.
     */
    public void setLocalPart(final String localPart) {
        this.localPart = localPart;
    }

    /**
     * XML^̖OԐړԂ܂B
     * 
     * @return Returns the namespacePrefix.
     */
    public String getNamespacePrefix() {
        return namespacePrefix;
    }

    /**
     * XML^̖OԐړݒ肵܂B
     * 
     * @param namespacePrefix
     *            The namespacePrefix to set.
     */
    public void setNamespacePrefix(final String namespacePrefix) {
        this.namespacePrefix = namespacePrefix;
    }

    /**
     * Java^XML^ւ̃VACUԂ܂B
     * 
     * @return Returns the serializer.
     */
    public Class getSerializer() {
        return serializer;
    }

    /**
     * Java^XML^ւ̃VACUݒ肵܂B
     * 
     * @param serializer
     *            The serializer to set.
     */
    public void setSerializer(final Class serializer) {
        this.serializer = serializer;
    }

    /**
     * XML^Java^ւ̃fVACUԂ܂B
     * 
     * @return Returns the deserializer.
     */
    public Class getDeserializer() {
        return deserializer;
    }

    /**
     * XML^Java^ւ̃fVACUݒ肵܂B
     * 
     * @param deserializer
     *            The deserializer to set.
     */
    public void setDeserializer(final Class deserializer) {
        this.deserializer = deserializer;
    }

    /**
     * GR[fBOX^CԂ܂B
     * 
     * @return Returns the encodingStyle.
     */
    public String getEncodingStyle() {
        return encodingStyle;
    }

    /**
     * GR[fBOX^Cݒ肵܂B
     * 
     * @param encodingStyle
     *            The encodingStyle to set.
     */
    public void setEncodingStyle(final String encodingStyle) {
        this.encodingStyle = encodingStyle;
    }
}