/*
 * The Seasar Software License, Version 1.1 Copyright (c) 2003-2004 The Seasar
 * Project. All rights reserved. Redistribution and use in source and binary
 * forms, with or without modification, are permitted provided that the
 * following conditions are met: 1. Redistributions of source code must retain
 * the above copyright notice, this list of conditions and the following
 * disclaimer. 2. Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution. 3. The
 * end-user documentation included with the redistribution, if any, must include
 * the following acknowledgement: "This product includes software developed by
 * the Seasar Project (http://www.seasar.org/)." Alternately, this
 * acknowledgement may appear in the software itself, if and wherever such
 * third-party acknowledgements normally appear. 4. Neither the name "The Seasar
 * Project" nor the names of its contributors may be used to endorse or promote
 * products derived from this software without specific prior written permission
 * of the Seasar Project. THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE SEASAR PROJECT OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.seasar.axis.client;

import java.lang.reflect.Method;
import java.net.URL;

import javax.xml.namespace.QName;
import javax.xml.rpc.Call;

import org.aopalliance.intercept.MethodInvocation;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.enum.Use;
import org.seasar.axis.S2AxisConstants;
import org.seasar.axis.encoding.AutoRegisterTypeMappingImpl;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.util.MethodUtil;

/**
 * JavaC^tF[XʂWebT[rXĂяo߂̃C^[Zv^łB
 * 
 * @author koichik
 */
public class DynamicInvocationInterceptor extends AbstractInterceptor {
    //instance fields
    protected final Service service;
    protected final String endPointAddress;

    /**
     * CX^X\z܂B <br>
     * r[̃^Cv}bsO悤ɃT[rX̃^Cv}bsOWXgݒ肵܂B
     * 
     * @param service
     *            T[rX
     * @param endPointAddress
     *            Gh|CgAhX
     */
    public DynamicInvocationInterceptor(final Service service, final String endPointAddress) {
        this.service = service;
        this.endPointAddress = endPointAddress;

        final TypeMappingRegistry tmr = service.getEngine().getTypeMappingRegistry();
        final AutoRegisterTypeMappingImpl autoTM = new AutoRegisterTypeMappingImpl(null);
        tmr.register(Use.DEFAULT.getEncoding(), autoTM);
    }

    /**
     * CX^X\z܂B
     * 
     * @param service
     *            T[rX
     * @param url
     *            Gh|CgAhXURL
     */
    public DynamicInvocationInterceptor(final Service service, final URL url) {
        this(service, url.toString());
    }

    /**
     * ^[Qbg܂̓T[rX̃\bhN܂B <br>
     * Ăяoꂽ\bh^[QbgŎĂꍇ̓^[Qbg̃\bhĂяo܂B
     * ^[QbgŎĂȂ΃T[rX̃\bhĂяo܂B
     * 
     * @param invocation
     *            \bhN
     */
    public Object invoke(final MethodInvocation invocation) throws Throwable {
        final Method method = invocation.getMethod();
        if (!MethodUtil.isAbstract(method)) {
            return invocation.proceed();
        }

        final Call call = service.createCall();
        call.setTargetEndpointAddress(endPointAddress);
        call.setOperationName(new QName(S2AxisConstants.OPERATION_NAMESPACE_URI, method.getName()));
        return call.invoke(invocation.getArguments());
    }
}