/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.axis.server.deployment;

import java.io.InputStream;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDDocument;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.deployment.wsdd.WSDDHandler;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.server.AxisServer;
import org.apache.axis.utils.XMLUtils;
import org.seasar.axis.server.DeployFailedException;
import org.seasar.axis.server.ServiceDef;
import org.seasar.axis.server.deployment.WSDDS2Handler;
import org.seasar.axis.server.deployment.WSDDS2Service;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.MetaDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.log.Logger;
import org.seasar.framework.message.MessageFormatter;
import org.seasar.framework.util.ResourceUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Deployer {
    private static final Logger logger;
    protected S2Container container;
    protected ServletContext servletContext;
    protected AxisServer axisEngine;
    protected WSDDEngineConfiguration configuration;
    protected WSDDDeployment deployment;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.axis.server.deployment.Deployer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public void setContainer(S2Container container) {
        this.container = container;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void deploy() {
        this.setupAxis();
        this.forEach(this.container.getRoot());
    }

    protected void setupAxis() {
        this.axisEngine = (AxisServer)this.servletContext.getAttribute("AxisEngine");
        this.configuration = (WSDDEngineConfiguration)this.axisEngine.getConfig();
        this.deployment = this.configuration.getDeployment();
    }

    protected void forEach(S2Container container) {
        this.process(container);
        int componentDefSize = container.getComponentDefSize();
        int i = 0;
        while (i < componentDefSize) {
            this.process(container.getComponentDef(i));
            ++i;
        }
        int childContainerSize = container.getChildSize();
        int i2 = 0;
        while (i2 < childContainerSize) {
            this.forEach(container.getChild(i2));
            ++i2;
        }
    }

    protected void process(S2Container container) {
        MetaDef[] metadataArray = container.getMetaDefs("s2axis:deploy");
        if (metadataArray != null) {
            int i = 0;
            while (i < metadataArray.length) {
                Object value = metadataArray[i].getValue();
                if (value instanceof String) {
                    String wsddFileName = (String)value;
                    this.deployWSDD(wsddFileName);
                    if (logger.isDebugEnabled()) {
                        logger.log("DAXS0001", new Object[]{wsddFileName});
                    }
                } else {
                    throw new DeployFailedException(MessageFormatter.getSimpleMessage((String)"EAXS0002", (Object[])new Object[]{value}));
                }
                ++i;
            }
        }
    }

    protected void process(ComponentDef componentDef) {
        MetaDef handlerMetaDef;
        MetaDef serviceMetaDef = componentDef.getMetaDef("s2axis:service");
        if (serviceMetaDef != null) {
            WSDDS2Service service = this.createWSDDS2Service(componentDef, serviceMetaDef);
            this.deployment.deployService((WSDDService)service);
            if (logger.isDebugEnabled()) {
                logger.log("DAXS0003", new Object[]{service.getQName()});
            }
        }
        if ((handlerMetaDef = componentDef.getMetaDef("s2axis:handler")) != null) {
            WSDDS2Handler handler = new WSDDS2Handler(componentDef);
            this.deployment.deployHandler((WSDDHandler)handler);
            if (logger.isDebugEnabled()) {
                logger.log("DAXS0004", new Object[]{handler.getQName()});
            }
        }
    }

    protected void deployWSDD(String wsddFileName) {
        try {
            InputStream is = ResourceUtil.getResourceAsStream((String)wsddFileName);
            WSDDDocument wsddDocument = new WSDDDocument(XMLUtils.newDocument((InputStream)is));
            wsddDocument.deploy(this.deployment);
        }
        catch (Exception e) {
            throw new DeployFailedException(e);
        }
    }

    public WSDDS2Service createWSDDS2Service(ComponentDef componentDef, MetaDef metaDef) {
        try {
            Object metadata = metaDef.getValue();
            if (metadata == null) {
                return new WSDDS2Service(componentDef);
            }
            if (metadata instanceof ServiceDef) {
                return new WSDDS2Service(componentDef, (ServiceDef)metadata);
            }
            if (metadata instanceof String) {
                return new WSDDS2Service(componentDef, this.getServiceElement((String)metadata));
            }
            throw new DeployFailedException();
        }
        catch (WSDDException e) {
            throw new DeployFailedException(e);
        }
    }

    protected Element getServiceElement(String wsddFileName) {
        try {
            InputStream is = ResourceUtil.getResourceAsStream((String)wsddFileName);
            Element documentElement = XMLUtils.newDocument((InputStream)is).getDocumentElement();
            Element[] serviceElements = this.getChildElements(documentElement, "service");
            if (serviceElements.length != 1) {
                throw new DeployFailedException(MessageFormatter.getSimpleMessage((String)"EAXS0005", (Object[])new Object[]{wsddFileName}));
            }
            return serviceElements[0];
        }
        catch (DeployFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeployFailedException(e);
        }
    }

    protected Element[] getChildElements(Element parent, String name) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element element;
            Node thisNode = children.item(i);
            if (thisNode instanceof Element && (element = (Element)thisNode).getLocalName().equals(name)) {
                result.add(element);
            }
            ++i;
        }
        return result.toArray(new Element[result.size()]);
    }
}

