/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.axis.client;

import java.lang.reflect.Method;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.encoding.TypeMapping;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.enum.Use;
import org.seasar.axis.encoding.AutoRegisterTypeMappingImpl;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.util.MethodUtil;

public class DynamicInvocationInterceptor
extends AbstractInterceptor {
    protected final Service service;
    protected final String endPointAddress;

    public DynamicInvocationInterceptor(Service service, String endPointAddress) {
        this.service = service;
        this.endPointAddress = endPointAddress;
        TypeMappingRegistry tmr = service.getEngine().getTypeMappingRegistry();
        AutoRegisterTypeMappingImpl autoTM = new AutoRegisterTypeMappingImpl(null);
        tmr.register(Use.DEFAULT.getEncoding(), (TypeMapping)autoTM);
    }

    public DynamicInvocationInterceptor(Service service, URL url) {
        this(service, url.toString());
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (!MethodUtil.isAbstract((Method)method)) {
            return invocation.proceed();
        }
        Call call = this.service.createCall();
        call.setTargetEndpointAddress(this.endPointAddress);
        call.setOperationName(new QName("http://soapinterop.org/", method.getName()));
        return call.invoke(invocation.getArguments());
    }
}

