/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.flex.message;

public class PatternTokenizer {
    public static final int STRING = 0;
    public static final int VARIABLE = 1;
    public static final int EOF = 9;
    private String pattern;
    private int position = 0;
    private String token;
    private int varIndex = -1;
    private int tokenType = 0;
    private int nextTokenType = 0;

    public PatternTokenizer(String pattern) {
        this.pattern = pattern;
    }

    public int getPosition() {
        return this.position;
    }

    public String getToken() {
        return this.token;
    }

    public int getVarIndex() {
        return this.varIndex;
    }

    public int getTokenType() {
        return this.tokenType;
    }

    public int getNextTokenType() {
        return this.nextTokenType;
    }

    public int next() {
        if (this.position >= this.pattern.length()) {
            this.token = null;
            this.tokenType = 9;
            this.nextTokenType = 9;
            return this.tokenType;
        }
        switch (this.nextTokenType) {
            case 0: {
                this.parseString();
                break;
            }
            case 1: {
                this.parseVariable();
                break;
            }
            default: {
                this.parseEof();
            }
        }
        return this.tokenType;
    }

    protected void parseString() {
        int varStartPos = this.pattern.indexOf("{", this.position);
        if (varStartPos < 0) {
            this.token = this.pattern.substring(this.position);
            this.nextTokenType = 9;
            this.position = this.pattern.length();
            this.tokenType = 0;
        } else {
            this.token = this.pattern.substring(this.position, varStartPos);
            this.tokenType = 0;
            boolean needNext = varStartPos == this.position;
            this.nextTokenType = 1;
            this.position = varStartPos + 1;
            if (needNext) {
                this.next();
            }
        }
    }

    protected void parseVariable() {
        int varEndPos = this.pattern.indexOf("}", this.position);
        if (varEndPos < 0) {
            throw new IllegalArgumentException(this.pattern);
        }
        this.token = null;
        this.varIndex = Integer.parseInt(this.pattern.substring(this.position, varEndPos));
        this.nextTokenType = 0;
        this.position = varEndPos + 1;
        this.tokenType = 1;
    }

    protected void parseEof() {
        this.token = null;
        this.tokenType = 9;
        this.nextTokenType = 9;
    }
}

