/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.flex.message;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.seasar.flex.message.Message;
import org.seasar.flex.message.MessageLogic;
import org.seasar.flex.message.MessageManager;
import org.seasar.flex.message.MessagePiece;
import org.seasar.flex.message.PatternTokenizer;
import org.seasar.flex.message.StringPiece;
import org.seasar.flex.message.VariablePiece;
import org.seasar.framework.util.LocaleUtil;
import org.seasar.framework.util.ResourceBundleUtil;

public class MessageLogicImpl
implements MessageLogic {
    public MessageManager getMessageManager(String path, String localeStr) {
        Locale locale = LocaleUtil.getLocale((String)localeStr);
        ResourceBundle bundle = ResourceBundleUtil.getBundle((String)path, (Locale)locale);
        return this.getMessageManager(bundle);
    }

    protected MessageManager getMessageManager(ResourceBundle bundle) {
        MessageManager manager = new MessageManager();
        Enumeration<String> e = bundle.getKeys();
        while (e.hasMoreElements()) {
            String messageCode = e.nextElement();
            String pattern = bundle.getString(messageCode);
            Message message = this.getMessage(pattern);
            manager.addMessage(messageCode, message);
        }
        return manager;
    }

    protected Message getMessage(String pattern) {
        Message message = new Message();
        message.setMessagePieces(this.getMessagePieces(pattern));
        return message;
    }

    protected List getMessagePieces(String pattern) {
        ArrayList<MessagePiece> pieces = new ArrayList<MessagePiece>();
        PatternTokenizer tokenizer = new PatternTokenizer(pattern);
        int tokenType = tokenizer.next();
        while (tokenType != 9) {
            switch (tokenType) {
                case 0: {
                    StringPiece strPiece = new StringPiece();
                    strPiece.setValue(tokenizer.getToken());
                    pieces.add(strPiece);
                    break;
                }
                case 1: {
                    VariablePiece varPiece = new VariablePiece();
                    varPiece.setIndex(tokenizer.getVarIndex());
                    pieces.add(varPiece);
                }
            }
            tokenType = tokenizer.next();
        }
        return pieces;
    }
}

