package test.org.seasar.dao.impl;

import org.seasar.dao.impl.BeanMetaDataImpl;
import org.seasar.dao.impl.InsertAutoStaticCommand;
import org.seasar.dao.unit.S2DaoTestCase;

public class InsertAutoStaticCommandTest extends S2DaoTestCase {

	public InsertAutoStaticCommandTest(String arg0) {
		super(arg0);
	}

	public void testExecuteTx() throws Exception {
		InsertAutoStaticCommand cmd = new InsertAutoStaticCommand(
				getDataSource(), new BeanMetaDataImpl(Employee.class,
						getDatabaseMetaData(), getDbms()));
		Employee emp = new Employee();
		emp.setEmpno(99);
		emp.setEname("hoge");
		Integer count = (Integer) cmd.execute(new Object[] { emp });
		assertEquals("1", new Integer(1), count);
	}
	
	public void testExecute2Tx() throws Exception {
		InsertAutoStaticCommand cmd = new InsertAutoStaticCommand(
				getDataSource(), new BeanMetaDataImpl(IdentityTable.class,
						getDatabaseMetaData(), getDbms()));
		
		IdentityTable table = new IdentityTable();
		table.setName("hoge");
		Integer count = (Integer) cmd.execute(new Object[] { table });
		assertEquals("1", new Integer(1), count);
		System.out.println(table.getId());
		assertTrue("2", table.getId() > 0);
	}
	
	public void testExecute3Tx() throws Exception {
		InsertAutoStaticCommand cmd = new InsertAutoStaticCommand(
				getDataSource(), new BeanMetaDataImpl(SeqTable.class,
						getDatabaseMetaData(), getDbms()));
		
		SeqTable table = new SeqTable();
		table.setName("hoge");
		Integer count = (Integer) cmd.execute(new Object[] { table });
		assertEquals("1", new Integer(1), count);
		System.out.println(table.getId());
		assertTrue("2", table.getId() > 0);
	}

	public void setUp() {
		include("j2ee.dicon");
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(InsertAutoStaticCommandTest.class);
	}

}