package test.org.seasar.dao.impl;

import java.util.List;

public interface EmployeeAutoDao {

	public Class BEAN = Employee.class;
	
	public String getEmployeeByDeptno_ARGS = "deptno";
	public String getEmployeeByDeptno_ORDER = "deptno asc, empno desc";
	public List getEmployeeByDeptno(int deptno);
	
	public String getEmployeesBySal_QUERY = "sal BETWEEN ? AND ? ORDER BY empno";
	public List getEmployeesBySal(Float minSal, Float maxSal);
	
	public String getEmployeesByEnameJob_ARGS = "enames, jobs";
	public String getEmployeesByEnameJob_QUERY = "ename IN /*enames*/('SCOTT','MARY') AND job IN /*jobs*/('ANALYST', 'FREE')";
	public List getEmployeesByEnameJob(List enames, List jobs);
	
	public List getEmployeesBySearchCondition(EmployeeSearchCondition dto);
	
	public List getEmployeesByEmployee(Employee dto);
	
	public String getEmployee_ARGS = "empno";
	public Employee getEmployee(int empno);
	
	public void insert(Employee employee);
	
	public void insertBatch(Employee[] employees);
	
	public void update(Employee employee);
	
	public void updateBatch(Employee[] employees);
	
	public void delete(Employee employee);
	
	public void deleteBatch(Employee[] employees);
}
