/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import javax.sql.DataSource;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.impl.AbstractAutoHandler;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.util.IntegerConversionUtil;

public class UpdateAutoHandler
extends AbstractAutoHandler {
    public UpdateAutoHandler(DataSource dataSource, BeanMetaData beanMetaData) {
        super(dataSource, beanMetaData);
    }

    protected void setupSql() {
        this.setSql(this.getBeanMetaData().getAutoUpdateSql());
    }

    protected Object[] getBindVariables(Object bean) {
        return this.getBeanMetaData().getAutoUpdateBindVariables(bean);
    }

    protected void postUpdateBean(Object bean, Object[] bindVariables) {
        BeanMetaData bmd = this.getBeanMetaData();
        if (bmd.hasVersionNoPropertyType()) {
            PropertyDesc pd = bmd.getVersionNoPropertyType().getPropertyDesc();
            Object value = pd.getValue(bean);
            int intValue = IntegerConversionUtil.toPrimitiveInt((Object)value) + 1;
            pd.setValue(bean, (Object)new Integer(intValue));
        }
        if (bmd.hasTimestampPropertyType()) {
            int i = 0;
            while (i < bmd.getPropertyTypeSize()) {
                PropertyType pt = bmd.getPropertyType(i);
                if (pt.isPersistent() && !pt.isPrimaryKey() && !pt.getPropertyName().equals("versionNo") && pt.getPropertyName().equalsIgnoreCase("timestamp")) {
                    PropertyDesc pd = pt.getPropertyDesc();
                    pd.setValue(bean, bindVariables[i]);
                    return;
                }
                ++i;
            }
        }
    }
}

