/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.RelationPropertyType;
import org.seasar.dao.impl.AbstractBeanMetaDataResultSetHandler;
import org.seasar.dao.impl.RelationKey;
import org.seasar.dao.impl.RelationRowCache;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.framework.beans.PropertyDesc;

public class BeanListMetaDataResultSetHandler
extends AbstractBeanMetaDataResultSetHandler {
    public BeanListMetaDataResultSetHandler(BeanMetaData beanMetaData) {
        super(beanMetaData);
    }

    public Object handle(ResultSet rs) throws SQLException {
        Set columnNames = this.createColumnNames(rs.getMetaData());
        ArrayList<Object> list = new ArrayList<Object>();
        int relSize = this.getBeanMetaData().getRelationPropertyTypeSize();
        RelationRowCache relRowCache = new RelationRowCache(relSize);
        while (rs.next()) {
            Object row = this.createRow(rs, columnNames);
            int i = 0;
            while (i < relSize) {
                RelationPropertyType rpt = this.getBeanMetaData().getRelationPropertyType(i);
                if (rpt != null) {
                    Object relRow = null;
                    HashMap relKeyValues = new HashMap();
                    RelationKey relKey = this.createRelationKey(rs, rpt, columnNames, relKeyValues);
                    if (relKey != null && (relRow = relRowCache.getRelationRow(i, relKey)) == null) {
                        relRow = this.createRelationRow(rs, rpt, columnNames, relKeyValues);
                        relRowCache.addRelationRow(i, relKey, relRow);
                    }
                    if (relRow != null) {
                        PropertyDesc pd = rpt.getPropertyDesc();
                        pd.setValue(row, relRow);
                    }
                }
                ++i;
            }
            list.add(row);
        }
        return list;
    }

    protected RelationKey createRelationKey(ResultSet rs, RelationPropertyType rpt, Set columnNames, Map relKeyValues) throws SQLException {
        ArrayList<Object> keyList = new ArrayList<Object>();
        BeanMetaData bmd = rpt.getBeanMetaData();
        int i = 0;
        while (i < rpt.getKeySize()) {
            PropertyType pt = bmd.getPropertyTypeByColumnName(rpt.getYourKey(i));
            ValueType valueType = pt.getValueType();
            String columnName = String.valueOf(pt.getColumnName()) + "_" + rpt.getRelationNo();
            if (!columnNames.contains(columnName)) {
                return null;
            }
            Object value = valueType.getValue(rs, columnName);
            if (value == null) {
                return null;
            }
            relKeyValues.put(columnName, value);
            keyList.add(value);
            ++i;
        }
        if (keyList.size() > 0) {
            Object[] keys = keyList.toArray();
            return new RelationKey(keys);
        }
        return null;
    }
}

