package test.org.seasar.extension.mock.servlet;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.extension.mock.servlet.MockHttpServletRequest;
import org.seasar.extension.mock.servlet.MockServletContext;

public class MockServletContextTest extends TestCase {

	private MockServletContext context_;

	public MockServletContextTest(String name) {
		super(name);
	}

	public void testCreateRequest() throws Exception {
		MockHttpServletRequest request = context_.createRequest("/hello.html");
		assertEquals("1", "/s2jsf-example", request.getContextPath());
		assertEquals("2", "/hello.html", request.getServletPath());

		request = context_.createRequest("/hello.html?aaa=hoge");
		assertEquals("3", "aaa=hoge", request.getQueryString());
	}

	protected void setUp() throws Exception {
		context_ = new MockServletContext("/s2jsf-example");
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(MockServletContextTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner
				.main(new String[] { MockServletContextTest.class.getName() });
	}
}