/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.seasar.framework.exception.ParseRuntimeException;
import org.seasar.framework.util.StringUtil;

public final class DateConversionUtil {
    private DateConversionUtil() {
    }

    public static Date toDate(Object o) {
        return DateConversionUtil.toDate(o, null);
    }

    public static Date toDate(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return DateConversionUtil.toDate((String)o, pattern);
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof Calendar) {
            return ((Calendar)o).getTime();
        }
        return DateConversionUtil.toDate(o.toString(), pattern);
    }

    public static Date toDate(String s, String pattern) {
        SimpleDateFormat sdf = DateConversionUtil.getDateFormat(s, pattern);
        try {
            return sdf.parse(s);
        }
        catch (ParseException ex) {
            throw new ParseRuntimeException(ex);
        }
    }

    public static SimpleDateFormat getDateFormat(String s, String pattern) {
        if (pattern != null) {
            return new SimpleDateFormat(pattern);
        }
        return DateConversionUtil.getDateFormat(s);
    }

    public static SimpleDateFormat getDateFormat(String s) {
        String pattern = DateConversionUtil.getPattern();
        String shortPattern = DateConversionUtil.removeDelimiter(pattern);
        String delimitor = DateConversionUtil.findDelimiter(s);
        if (delimitor == null) {
            if (s.length() == shortPattern.length()) {
                return new SimpleDateFormat(shortPattern);
            }
            if (s.length() == shortPattern.length() + 2) {
                return new SimpleDateFormat(StringUtil.replace(shortPattern, "yy", "yyyy"));
            }
        } else {
            String[] array = StringUtil.split(s, delimitor);
            int i = 0;
            while (i < array.length) {
                if (array[i].length() == 4) {
                    pattern = StringUtil.replace(pattern, "yy", "yyyy");
                    break;
                }
                ++i;
            }
            return new SimpleDateFormat(pattern);
        }
        return new SimpleDateFormat();
    }

    public static SimpleDateFormat getDateFormat() {
        return new SimpleDateFormat(DateConversionUtil.getPattern());
    }

    public static SimpleDateFormat getY4DateFormat() {
        return new SimpleDateFormat(DateConversionUtil.getY4Pattern());
    }

    public static String getY4Pattern() {
        String pattern = DateConversionUtil.getPattern();
        if (pattern.indexOf("yyyy") < 0) {
            pattern = StringUtil.replace(pattern, "yy", "yyyy");
        }
        return pattern;
    }

    public static String getPattern() {
        SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance(3);
        String pattern = df.toPattern();
        int index = pattern.indexOf(32);
        if (index > 0) {
            pattern = pattern.substring(0, index);
        }
        if (pattern.indexOf("MM") < 0) {
            pattern = StringUtil.replace(pattern, "M", "MM");
        }
        if (pattern.indexOf("dd") < 0) {
            pattern = StringUtil.replace(pattern, "d", "dd");
        }
        return pattern;
    }

    public static String findDelimiter(String value) {
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (!Character.isDigit(c)) {
                return Character.toString(c);
            }
            ++i;
        }
        return null;
    }

    public static String removeDelimiter(String pattern) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < pattern.length()) {
            char c = pattern.charAt(i);
            if (c == 'y' || c == 'M' || c == 'd') {
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }
}

