/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.Binary;
import org.hsqldb.HsqlException;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.lib.HsqlByteArrayInputStream;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowInputInterface;

public abstract class RowInputBase
extends HsqlByteArrayInputStream {
    static final int NO_POS = -1;
    protected int filePos = -1;
    protected int nextPos = -1;
    protected int size;
    protected boolean makeSystemId;

    public static RowInputInterface newRowInput(int n) throws HsqlException {
        try {
            if (n == 1) {
                return new RowInputBinary();
            }
            Class<?> clazz = Class.forName("org.hsqldb.RowInputLegacy");
            return (RowInputInterface)clazz.newInstance();
        }
        catch (Exception exception) {
            throw Trace.error(66, 111);
        }
    }

    public RowInputBase() {
        this(new byte[4]);
    }

    public RowInputBase(byte[] byArray) {
        super(byArray);
        this.size = byArray.length;
    }

    public int getPos() throws IOException {
        if (this.filePos == -1) {
            throw new IOException(Trace.getMessage(178));
        }
        return this.filePos;
    }

    public int getNextPos() throws IOException {
        if (this.nextPos == -1) {
            throw new IOException(Trace.getMessage(179));
        }
        return this.nextPos;
    }

    public int getSize() {
        return this.size;
    }

    public abstract int readIntData() throws IOException;

    public abstract int readType() throws IOException;

    public abstract String readString() throws IOException;

    protected abstract boolean checkNull() throws IOException;

    protected abstract String readChar(int var1) throws IOException, HsqlException;

    protected abstract Integer readSmallint() throws IOException, HsqlException;

    protected abstract Integer readInteger() throws IOException, HsqlException;

    protected abstract Long readBigint() throws IOException, HsqlException;

    protected abstract Double readReal(int var1) throws IOException, HsqlException;

    protected abstract BigDecimal readDecimal() throws IOException, HsqlException;

    protected abstract Boolean readBit() throws IOException, HsqlException;

    protected abstract Time readTime() throws IOException, HsqlException;

    protected abstract Date readDate() throws IOException, HsqlException;

    protected abstract Timestamp readTimestamp() throws IOException, HsqlException;

    protected abstract Object readOther() throws IOException, HsqlException;

    protected abstract Binary readBinary(int var1) throws IOException, HsqlException;

    public void setSystemId(boolean bl) {
        this.makeSystemId = bl;
    }

    public Object[] readData(int[] nArray) throws IOException, HsqlException {
        int n = nArray.length;
        Object[] objectArray = new Object[n];
        if (this.makeSystemId) {
            --n;
        }
        for (int i = 0; i < n; ++i) {
            if (this.checkNull()) continue;
            Object object = null;
            int n2 = nArray[i];
            switch (n2) {
                case -1: 
                case 0: 
                case 1: 
                case 12: 
                case 100: {
                    object = this.readChar(n2);
                    break;
                }
                case -6: 
                case 5: {
                    object = this.readSmallint();
                    break;
                }
                case 4: {
                    object = this.readInteger();
                    break;
                }
                case -5: {
                    object = this.readBigint();
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    object = this.readReal(n2);
                    break;
                }
                case 2: 
                case 3: {
                    object = this.readDecimal();
                    break;
                }
                case 91: {
                    object = this.readDate();
                    break;
                }
                case 92: {
                    object = this.readTime();
                    break;
                }
                case 93: {
                    object = this.readTimestamp();
                    break;
                }
                case 16: {
                    object = this.readBit();
                    break;
                }
                case 1111: {
                    object = this.readOther();
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    object = this.readBinary(n2);
                    break;
                }
                default: {
                    throw Trace.error(20, Types.getTypeString(n2));
                }
            }
            objectArray[i] = object;
        }
        return objectArray;
    }

    public void resetRow(int n, int n2) throws IOException {
        this.mark = 0;
        this.reset();
        if (this.buf.length < n2) {
            this.buf = new byte[n2];
        }
        this.filePos = n;
        this.size = this.count = n2;
        this.pos = 4;
        this.buf[0] = (byte)(n2 >>> 24 & 0xFF);
        this.buf[1] = (byte)(n2 >>> 16 & 0xFF);
        this.buf[2] = (byte)(n2 >>> 8 & 0xFF);
        this.buf[3] = (byte)(n2 >>> 0 & 0xFF);
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int skipBytes(int n) throws IOException {
        throw new RuntimeException(Trace.getMessage(127));
    }

    public String readLine() throws IOException {
        throw new RuntimeException(Trace.getMessage(128));
    }
}

