package org.seasar.jsf.template.impl;

import javax.faces.component.UIComponent;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;

import org.seasar.jsf.component.UIText;

/**
 * @author higa
 *  
 */
public class UITextBuilder extends AbstractComponentTreeBuilder {

	private String data_;
	
	public UITextBuilder(String data) {
		data_ = data;
	}
	
	public String getData() {
		return data_;
	}

	protected UIComponent createComponent() {
		return new UIText(data_);
	}
	
	/**
	 * @see org.seasar.jsf.template.ComponentTreeBuilder#buildTree(javax.faces.component.UIComponent)
	 */
	public void buildTree(UIComponent parent) {
		if (!(parent instanceof UISelectOne) && !(parent instanceof UISelectMany)) {
			super.buildTree(parent);
		}
	}
}