package org.seasar.jsf.template.impl;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

import org.seasar.framework.util.StringUtil;
import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.component.ForEach;
import org.seasar.jsf.util.BindingUtil;
import org.xml.sax.Attributes;

/**
 * @author higa
 *  
 */
public class ForEachBuilder extends AbstractUIComponentBuilder {

	public ForEachBuilder(String namespaceURI, String localName,
			String qName, Attributes attributes) {
		
		super(namespaceURI, localName, qName, attributes);
		addCustomPropertyName(JsfConstants.ITEMS_ATTR);
	}
	
	protected void setProperties(UIComponent component) {
		super.setProperties(component);
		String itemsRef = (String) getProperty(JsfConstants.ITEMS_ATTR);
		if (!StringUtil.isEmpty(itemsRef)) {
			if (BindingUtil.isValueReference(itemsRef)) {
				FacesContext ctx = FacesContext.getCurrentInstance();
				Application app = ctx.getApplication();
				ValueBinding binding = app.createValueBinding(itemsRef);
				component.setValueBinding(JsfConstants.ITEMS_ATTR, binding);
			}
		}
	}

	protected UIComponent createComponent() {
		return new ForEach();
	}
}