package org.seasar.jsf.component;

import java.io.IOException;

import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

/**
 * @author higa
 *  
 */
public class UIText extends UIComponentBase {

	public static final String COMPONENT_TYPE = "org.seasar.jsf.Text";

	public static final String COMPONENT_FAMILY = "javax.faces.Output";

	private static final String DEFAULT_RENDERER_TYPE = "org.seasar.jsf.Text";

	private String value_;

	public UIText() {
	}

	public UIText(String value) {
		value_ = value;
		setRendererType(DEFAULT_RENDERER_TYPE);
	}
	
	public String getValue() {
		return value_;
	}

	/**
	 * @see javax.faces.component.UIComponent#getFamily()
	 */
	public String getFamily() {
		return COMPONENT_FAMILY;
	}

	public void encodeBegin(FacesContext context) throws IOException {
		if (context == null) {
			throw new NullPointerException("context");
		}
		if (!isRendered()) {
			return;
		}
		ResponseWriter out = context.getResponseWriter();
		out.write(value_);
	}

	public void encodeEnd(FacesContext context) throws IOException {
		if (context == null) {
			throw new NullPointerException("context");
		}
		if (!isRendered()) {
			return;
		}
	}
	
	public Object saveState(FacesContext context) {
		Object[] values = new Object[2];
		values[0] = super.saveState(context);
		values[1] = value_;
		return values;
	}

	public void restoreState(FacesContext context, Object state) {
		Object values[] = (Object[]) state;
		super.restoreState(context, values[0]);
		value_ = (String) values[1];
	}
}