/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.template.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.StringUtil;
import org.seasar.jsf.template.ComponentTreeBuilder;
import org.seasar.jsf.template.impl.AbstractComponentTreeBuilder;
import org.seasar.jsf.util.BindingUtil;
import org.xml.sax.Attributes;

public abstract class AbstractUIComponentBuilder
extends AbstractComponentTreeBuilder {
    private String namespaceURI_;
    private String localName_;
    private String qName_;
    private Map properties_ = new HashMap();
    private Set customPropertyNames_ = new HashSet();

    public AbstractUIComponentBuilder(String namespaceURI, String localName, String qName, Attributes attributes) {
        this.namespaceURI_ = namespaceURI;
        this.localName_ = localName;
        this.qName_ = qName;
        this.setupProperties(attributes);
        this.renameProperties();
    }

    public String getNamespaceURI() {
        return this.namespaceURI_;
    }

    public String getLocalName() {
        return this.localName_;
    }

    public String getQName() {
        return this.qName_;
    }

    public void buildTree(UIComponent parent) {
        UIComponent component = this.createComponent();
        this.setProperties(component);
        parent.getChildren().add(component);
        int i = 0;
        while (i < this.getChildCount()) {
            ComponentTreeBuilder child = this.getChild(i);
            child.buildTree(component);
            ++i;
        }
    }

    protected Map getProperties() {
        return this.properties_;
    }

    protected Object getProperty(String propertyName) {
        return this.properties_.get(propertyName);
    }

    protected void setupProperties(Attributes attributes) {
        int length = attributes.getLength();
        int i = 0;
        while (i < length) {
            if ("http://www.seasar.org/jsf".equals(attributes.getURI(i))) {
                this.properties_.put(attributes.getLocalName(i), attributes.getValue(i));
            } else if (this.properties_.get(attributes.getQName(i)) == null) {
                this.properties_.put(attributes.getQName(i), attributes.getValue(i));
            }
            ++i;
        }
    }

    protected void renameProperties() {
        this.renameProperty("class", "styleClass");
    }

    protected void renameProperty(String from, String to) {
        if (this.properties_.containsKey(from)) {
            Object value = this.properties_.remove(from);
            this.properties_.put(to, value);
        }
    }

    protected void addCustomPropertyName(String propertyName) {
        this.customPropertyNames_.add(propertyName);
    }

    protected boolean isCustomProperty(String propertyName) {
        return this.customPropertyNames_.contains(propertyName);
    }

    protected void setProperties(UIComponent component) {
        ArrayList<String> bindingPropertyNames = new ArrayList<String>();
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(component.getClass());
        Iterator i = this.getProperties().keySet().iterator();
        while (i.hasNext()) {
            String propertyName = (String)i.next();
            Object value = this.getProperties().get(propertyName);
            String s = (String)value;
            if (StringUtil.isEmpty((String)s) || this.isCustomProperty(propertyName)) continue;
            if (BindingUtil.isValueReference(s)) {
                FacesContext ctx = FacesContext.getCurrentInstance();
                Application app = ctx.getApplication();
                ValueBinding binding = app.createValueBinding(s);
                component.setValueBinding(propertyName, binding);
                bindingPropertyNames.add(propertyName);
                continue;
            }
            if (beanDesc.hasPropertyDesc(propertyName)) {
                PropertyDesc pd = beanDesc.getPropertyDesc(propertyName);
                value = pd.convertIfNeed(value);
            }
            component.getAttributes().put(propertyName, value);
        }
        component.getAttributes().put("_BINDING_PROPERTY_NAMES_", bindingPropertyNames);
    }
}

