/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.convert;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import javax.faces.convert.DateTimeConverter;
import org.seasar.framework.util.DateConversionUtil;
import org.seasar.jsf.util.MessageUtil;

public class DateTimeConverterX
extends DateTimeConverter {
    protected static final String CONVERSION_MESSAGE_ID = "javax.faces.convert.DateTimeConverter.CONVERSION";
    protected static final String TYPE_DATE = "date";
    protected static final String TYPE_TIME = "time";
    protected static final String TYPE_BOTH = "both";
    protected static final String STYLE_DEFAULT = "default";
    protected static final String STYLE_MEDIUM = "medium";
    protected static final String STYLE_SHORT = "short";
    protected static final String STYLE_LONG = "long";
    protected static final String STYLE_FULL = "full";

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (component == null) {
            throw new NullPointerException("component");
        }
        if (value != null && (value = value.trim()).length() > 0) {
            DateFormat format = this.getDateFormat(value);
            if (format == null) {
                format = DateConversionUtil.getDateFormat((String)value);
            }
            format.setLenient(true);
            TimeZone tz = this.getTimeZone();
            if (tz != null) {
                format.setTimeZone(tz);
            }
            try {
                return format.parse(value);
            }
            catch (ParseException e) {
                throw new ConverterException(MessageUtil.getErrorMessage(CONVERSION_MESSAGE_ID, new Object[]{value, component.getId()}), (Throwable)e);
            }
        }
        return null;
    }

    protected DateFormat getDateFormat(String value) {
        if (this.getPattern() != null) {
            return new SimpleDateFormat(this.getPattern(), this.getLocale());
        }
        if (this.isDefaultStyle()) {
            return DateConversionUtil.getDateFormat((String)value);
        }
        return this.getDateFormatForType();
    }

    protected boolean isDefaultStyle() {
        return STYLE_DEFAULT.equalsIgnoreCase(this.getDateStyle()) && STYLE_DEFAULT.equalsIgnoreCase(this.getTimeStyle());
    }

    protected DateFormat getDateFormatForType() {
        String type = this.getType();
        if (type.equals(TYPE_DATE)) {
            return DateFormat.getDateInstance(this.calcStyle(this.getDateStyle()), this.getLocale());
        }
        if (type.equals(TYPE_TIME)) {
            return DateFormat.getTimeInstance(this.calcStyle(this.getTimeStyle()), this.getLocale());
        }
        if (type.equals(TYPE_BOTH)) {
            return DateFormat.getDateTimeInstance(this.calcStyle(this.getDateStyle()), this.calcStyle(this.getTimeStyle()), this.getLocale());
        }
        return null;
    }

    protected int calcStyle(String name) {
        if (name.equals(STYLE_DEFAULT)) {
            return 2;
        }
        if (name.equals(STYLE_MEDIUM)) {
            return 2;
        }
        if (name.equals(STYLE_SHORT)) {
            return 3;
        }
        if (name.equals(STYLE_LONG)) {
            return 1;
        }
        if (name.equals(STYLE_FULL)) {
            return 0;
        }
        return 2;
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (component == null) {
            throw new NullPointerException("component");
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        DateFormat format = this.getDateFormat();
        if (this.getTimeZone() != null) {
            format.setTimeZone(this.getTimeZone());
        }
        try {
            return format.format(value);
        }
        catch (Exception ignore) {
            return value.toString();
        }
    }

    protected DateFormat getDateFormat() {
        if (this.getPattern() != null) {
            return new SimpleDateFormat(this.getPattern(), this.getLocale());
        }
        if (this.isDefaultStyle()) {
            return DateConversionUtil.getY4DateFormat();
        }
        return this.getDateFormatForType();
    }
}

