/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.myfaces.renderkit.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.UISelectOne;
import javax.faces.component.html.HtmlSelectOneRadio;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import net.sourceforge.myfaces.renderkit.RendererUtils;
import net.sourceforge.myfaces.renderkit.html.HTML;
import net.sourceforge.myfaces.renderkit.html.HtmlRenderer;
import net.sourceforge.myfaces.renderkit.html.HtmlRendererUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HtmlRadioRendererBase
extends HtmlRenderer {
    private static final Log log = LogFactory.getLog((Class)(class$net$sourceforge$myfaces$renderkit$html$HtmlRadioRendererBase == null ? (class$net$sourceforge$myfaces$renderkit$html$HtmlRadioRendererBase = HtmlRadioRendererBase.class$("net.sourceforge.myfaces.renderkit.html.HtmlRadioRendererBase")) : class$net$sourceforge$myfaces$renderkit$html$HtmlRadioRendererBase));
    private static final String PAGE_DIRECTION = "pageDirection";
    private static final String LINE_DIRECTION = "lineDirection";
    static /* synthetic */ Class class$net$sourceforge$myfaces$renderkit$html$HtmlRadioRendererBase;
    static /* synthetic */ Class class$javax$faces$component$UISelectOne;
    static /* synthetic */ Class class$javax$faces$component$UIOutput;

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Converter converter;
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$javax$faces$component$UISelectOne == null ? (class$javax$faces$component$UISelectOne = HtmlRadioRendererBase.class$("javax.faces.component.UISelectOne")) : class$javax$faces$component$UISelectOne);
        UISelectOne selectOne = (UISelectOne)uiComponent;
        String layout = this.getLayout((UIComponent)selectOne);
        boolean pageDirectionLayout = true;
        if (layout != null) {
            if (layout.equals(PAGE_DIRECTION)) {
                pageDirectionLayout = true;
            } else if (layout.equals(LINE_DIRECTION)) {
                pageDirectionLayout = false;
            } else {
                log.error((Object)("Wrong layout attribute for component " + selectOne.getClientId(facesContext) + ": " + layout));
            }
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = selectOne.getClientId(facesContext);
        writer.startElement("table", (UIComponent)selectOne);
        HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)selectOne, HTML.SELECT_TABLE_PASSTHROUGH_ATTRIBUTES);
        writer.writeAttribute("id", (Object)clientId, null);
        if (!pageDirectionLayout) {
            writer.startElement("tr", (UIComponent)selectOne);
        }
        List selectItemList = RendererUtils.getSelectItemList(selectOne);
        try {
            converter = RendererUtils.findUIOutputConverter(facesContext, (UIOutput)selectOne);
        }
        catch (FacesException e) {
            log.error((Object)("Error finding Converter for component with id " + uiComponent.getClientId(facesContext)));
            converter = null;
        }
        Object currentValue = selectOne.getValue();
        Iterator it = selectItemList.iterator();
        while (it.hasNext()) {
            SelectItem selectItem = (SelectItem)it.next();
            Object itemValue = selectItem.getValue();
            String itemStrValue = converter == null ? itemValue.toString() : converter.getAsString(facesContext, (UIComponent)selectOne, itemValue);
            writer.write("\t\t");
            if (pageDirectionLayout) {
                writer.startElement("tr", (UIComponent)selectOne);
            }
            writer.startElement("td", (UIComponent)selectOne);
            writer.startElement("label", (UIComponent)selectOne);
            this.renderRadio(facesContext, (UIInput)selectOne, itemStrValue, selectItem.getLabel(), currentValue == null && itemValue == null || currentValue != null && currentValue.equals(itemValue), false);
            writer.endElement("label");
            writer.endElement("td");
            if (!pageDirectionLayout) continue;
            writer.endElement("tr");
        }
        if (!pageDirectionLayout) {
            writer.endElement("tr");
        }
        writer.endElement("table");
    }

    protected String getLayout(UIComponent selectOne) {
        if (selectOne instanceof HtmlSelectOneRadio) {
            return ((HtmlSelectOneRadio)selectOne).getLayout();
        }
        return (String)selectOne.getAttributes().get("layout");
    }

    protected String getStyleClass(UISelectOne selectOne) {
        if (selectOne instanceof HtmlSelectOneRadio) {
            return ((HtmlSelectOneRadio)selectOne).getStyleClass();
        }
        return (String)selectOne.getAttributes().get("styleClass");
    }

    protected void renderRadio(FacesContext facesContext, UIInput uiComponent, String value, String label, boolean checked, boolean renderId) throws IOException {
        String clientId = uiComponent.getClientId(facesContext);
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", (UIComponent)uiComponent);
        writer.writeAttribute("type", (Object)"radio", null);
        writer.writeAttribute("name", (Object)clientId, null);
        if (renderId) {
            writer.writeAttribute("id", (Object)clientId, null);
        }
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (value != null && value.length() > 0) {
            writer.writeAttribute("value", (Object)value, null);
        }
        HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)uiComponent, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        if (this.isDisabled(facesContext, (UIComponent)uiComponent)) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        if (label != null && label.length() > 0) {
            writer.write("&nbsp;");
            writer.writeText((Object)label, null);
        }
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        if (uiComponent instanceof HtmlSelectOneRadio) {
            return ((HtmlSelectOneRadio)uiComponent).isDisabled();
        }
        return RendererUtils.getBooleanAttribute(uiComponent, "disabled", false);
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        RendererUtils.checkParamValidity(facesContext, uiComponent, null);
        if (uiComponent instanceof UIInput) {
            HtmlRendererUtils.decodeUIInput(facesContext, uiComponent);
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$javax$faces$component$UIOutput == null ? (class$javax$faces$component$UIOutput = HtmlRadioRendererBase.class$("javax.faces.component.UIOutput")) : class$javax$faces$component$UIOutput);
        return RendererUtils.getConvertedUIOutputValue(facesContext, (UIOutput)uiComponent, submittedValue);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

