/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.myfaces.custom.fileupload;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.myfaces.custom.fileupload.MultipartRequestWrapper;

public class MultipartFilter
implements Filter {
    private int maxFileSize = 0xA00000;

    public void init(FilterConfig filterConfig) {
        String param = filterConfig.getInitParameter("maxFileSize");
        if (param != null) {
            param = param.toLowerCase();
            int factor = 1;
            String number = param;
            if (param.endsWith("m")) {
                factor = 0x100000;
                number = param.substring(0, param.length() - 1);
            } else if (param.endsWith("k")) {
                factor = 1024;
                number = param.substring(0, param.length() - 1);
            }
            this.maxFileSize = Integer.parseInt(number) * factor;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(response instanceof HttpServletResponse)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String type = httpRequest.getHeader("Content-Type");
        if (type != null && type.startsWith("multipart/form-data")) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            MultipartRequestWrapper requestWrapper = new MultipartRequestWrapper(httpRequest, this.maxFileSize);
            chain.doFilter((ServletRequest)requestWrapper, response);
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

