/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.myfaces.component.html.ext;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;

class _SerializableDataModel
extends DataModel
implements Serializable {
    protected int _first;
    protected int _rows;
    protected int _rowCount;
    protected List _list;
    private transient int _rowIndex = -1;

    public _SerializableDataModel(int first, int rows, DataModel dataModel) {
        this._first = first;
        this._rows = rows;
        this._rowCount = dataModel.getRowCount();
        if (this._rows <= 0) {
            this._rows = this._rowCount - first;
        }
        this._list = new ArrayList(rows);
        for (int i = 0; i < this._rows; ++i) {
            dataModel.setRowIndex(this._first + i);
            if (!dataModel.isRowAvailable()) break;
            this._list.add(dataModel.getRowData());
        }
        this._rowIndex = -1;
        DataModelListener[] dataModelListeners = dataModel.getDataModelListeners();
        for (int i = 0; i < dataModelListeners.length; ++i) {
            DataModelListener dataModelListener = dataModelListeners[i];
            this.addDataModelListener(dataModelListener);
        }
    }

    protected _SerializableDataModel() {
    }

    public int getFirst() {
        return this._first;
    }

    public void setFirst(int first) {
        this._first = first;
    }

    public int getRows() {
        return this._rows;
    }

    public void setRows(int rows) {
        this._rows = rows;
    }

    public boolean isRowAvailable() {
        return this._rowIndex >= this._first && this._rowIndex < this._first + this._rows && this._rowIndex < this._rowCount && this._list.size() > this._rowIndex - this._first;
    }

    public int getRowCount() {
        return this._rowCount;
    }

    public Object getRowData() {
        if (!this.isRowAvailable()) {
            throw new IllegalStateException();
        }
        return this._list.get(this._rowIndex - this._first);
    }

    public int getRowIndex() {
        return this._rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException();
        }
        int oldRowIndex = this._rowIndex;
        this._rowIndex = rowIndex;
        if (oldRowIndex != this._rowIndex) {
            Object data = this.isRowAvailable() ? this.getRowData() : null;
            DataModelEvent event = new DataModelEvent((DataModel)this, this._rowIndex, data);
            DataModelListener[] listeners = this.getDataModelListeners();
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].rowSelected(event);
            }
        }
    }

    public Object getWrappedData() {
        return this._list;
    }

    public void setWrappedData(Object obj) {
        if (obj != null) {
            throw new IllegalArgumentException("Cannot set wrapped data of _SerializableDataModel");
        }
    }
}

