/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import groovy.lang.GroovyRuntimeException;
import groovy.lang.MissingClassException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CompileUnit;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.classgen.BytecodeHelper;
import org.codehaus.groovy.classgen.ClassGenerator;
import org.codehaus.groovy.classgen.ClassGeneratorException;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.CodeVisitor;

public class DummyClassGenerator
extends ClassGenerator {
    private ClassVisitor cw;
    private CodeVisitor cv;
    private GeneratorContext context;
    private String sourceFile;
    private ClassNode classNode;
    private String internalClassName;
    private String internalBaseClassName;
    Map classCache = new HashMap();

    public DummyClassGenerator(GeneratorContext context, ClassVisitor classVisitor, ClassLoader classLoader, String sourceFile) {
        super(classLoader);
        this.classCache.put("int", Integer.TYPE);
        this.classCache.put("byte", Byte.TYPE);
        this.classCache.put("short", Short.TYPE);
        this.classCache.put("char", Character.TYPE);
        this.classCache.put("boolean", Boolean.TYPE);
        this.classCache.put("long", Long.TYPE);
        this.classCache.put("double", Double.TYPE);
        this.classCache.put("float", Float.TYPE);
        this.context = context;
        this.cw = classVisitor;
        this.sourceFile = sourceFile;
    }

    public void visitClass(ClassNode classNode) {
        try {
            this.classNode = classNode;
            this.internalClassName = BytecodeHelper.getClassInternalName(classNode.getName());
            classNode.setSuperClass(this.checkValidType(classNode.getSuperClass(), classNode, "Must be a valid base class"));
            String[] interfaces = classNode.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                interfaces[i] = this.checkValidType(interfaces[i], classNode, "Must be a valid interface name");
            }
            this.internalBaseClassName = BytecodeHelper.getClassInternalName(classNode.getSuperClass());
            this.cw.visit(classNode.getModifiers(), this.internalClassName, this.internalBaseClassName, BytecodeHelper.getClassInternalNames(classNode.getInterfaces()), this.sourceFile);
            classNode.visitContents(this);
            Iterator iter = this.innerClasses.iterator();
            while (iter.hasNext()) {
                ClassNode innerClass = (ClassNode)iter.next();
                String innerClassName = innerClass.getName();
                String innerClassInternalName = BytecodeHelper.getClassInternalName(innerClassName);
                String outerClassName = this.internalClassName;
                MethodNode enclosingMethod = innerClass.getEnclosingMethod();
                if (enclosingMethod != null) {
                    outerClassName = null;
                }
                this.cw.visitInnerClass(innerClassInternalName, outerClassName, innerClassName, innerClass.getModifiers());
            }
            this.cw.visitEnd();
        }
        catch (GroovyRuntimeException e) {
            e.setModule(classNode.getModule());
            throw e;
        }
    }

    public void visitConstructor(ConstructorNode node) {
        this.visitParameters(node, node.getParameters());
        String methodType = BytecodeHelper.getMethodDescriptor("void", node.getParameters());
        this.cv = this.cw.visitMethod(node.getModifiers(), "<init>", methodType, null, null);
        this.cv.visitTypeInsn(187, "java/lang/RuntimeException");
        this.cv.visitInsn(89);
        this.cv.visitLdcInsn((Object)"not intended for execution");
        this.cv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/String;)V");
        this.cv.visitInsn(191);
        this.cv.visitMaxs(0, 0);
    }

    public void visitMethod(MethodNode node) {
        this.visitParameters(node, node.getParameters());
        node.setReturnType(this.checkValidType(node.getReturnType(), node, "Must be a valid return type"));
        String methodType = BytecodeHelper.getMethodDescriptor(node.getReturnType(), node.getParameters());
        this.cv = this.cw.visitMethod(node.getModifiers(), node.getName(), methodType, null, null);
        this.cv.visitTypeInsn(187, "java/lang/RuntimeException");
        this.cv.visitInsn(89);
        this.cv.visitLdcInsn((Object)"not intended for execution");
        this.cv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/String;)V");
        this.cv.visitInsn(191);
        this.cv.visitMaxs(0, 0);
    }

    public void visitField(FieldNode fieldNode) {
        fieldNode.setType(this.checkValidType(fieldNode.getType(), fieldNode, "Must be a valid field class for field: " + fieldNode.getName()));
        this.cw.visitField(fieldNode.getModifiers(), fieldNode.getName(), BytecodeHelper.getTypeDescription(fieldNode.getType()), null, null);
    }

    public void visitProperty(PropertyNode statement) {
    }

    protected String checkValidType(String type, ASTNode node, String message) {
        if (type != null && type.length() == 0) {
            return "java.lang.Object";
        }
        if (type.endsWith("[]")) {
            String postfix = "[]";
            String prefix = type.substring(0, type.length() - 2);
            return this.checkValidType(prefix, node, message) + postfix;
        }
        int idx = type.indexOf(36);
        if (idx > 0) {
            String postfix = type.substring(idx);
            String prefix = type.substring(0, idx);
            return this.checkValidType(prefix, node, message) + postfix;
        }
        if (BytecodeHelper.isPrimitiveType(type) || "void".equals(type)) {
            return type;
        }
        String original = type;
        if ((type = this.resolveClassName(type)) != null) {
            return type;
        }
        throw new MissingClassException(original, node, message + " for class: " + this.classNode.getName());
    }

    protected String resolveClassName(String type) {
        return this.classNode.resolveClassName(type);
    }

    protected static boolean isPrimitiveFieldType(String type) {
        return type.equals("java.lang.String") || type.equals("java.lang.Integer") || type.equals("java.lang.Double") || type.equals("java.lang.Long") || type.equals("java.lang.Float");
    }

    protected Class loadClass(String name) {
        if (name.equals(this.classNode.getName())) {
            return Object.class;
        }
        if (name == null) {
            return null;
        }
        if (name.length() == 0) {
            return Object.class;
        }
        if ("void".equals(name)) {
            return Void.TYPE;
        }
        if ("boolean".equals(name)) {
            return Boolean.TYPE;
        }
        if ("byte".equals(name)) {
            return Byte.TYPE;
        }
        if ("short".equals(name)) {
            return Short.TYPE;
        }
        if ("char".equals(name)) {
            return Character.TYPE;
        }
        if ("int".equals(name)) {
            return Integer.TYPE;
        }
        if ("long".equals(name)) {
            return Long.TYPE;
        }
        if ("float".equals(name)) {
            return Float.TYPE;
        }
        if ("double".equals(name)) {
            return Double.TYPE;
        }
        name = BytecodeHelper.formatNameForClassLoading(name);
        try {
            Class cls = (Class)this.classCache.get(name);
            if (cls != null) {
                return cls;
            }
            CompileUnit compileUnit = this.getCompileUnit();
            if (compileUnit != null) {
                cls = compileUnit.loadClass(name);
                this.classCache.put(name, cls);
                return cls;
            }
            throw new ClassGeneratorException("Could not load class: " + name);
        }
        catch (ClassNotFoundException e) {
            throw new ClassGeneratorException("Error when compiling class: " + this.classNode.getName() + ". Reason: could not load class: " + name + " reason: " + e, e);
        }
    }

    protected CompileUnit getCompileUnit() {
        CompileUnit answer = this.classNode.getCompileUnit();
        if (answer == null) {
            answer = this.context.getCompileUnit();
        }
        return answer;
    }

    protected void visitParameters(ASTNode node, Parameter[] parameters) {
        int size = parameters.length;
        for (int i = 0; i < size; ++i) {
            this.visitParameter(node, parameters[i]);
        }
    }

    protected void visitParameter(ASTNode node, Parameter parameter) {
        if (!parameter.isDynamicType()) {
            parameter.setType(this.checkValidType(parameter.getType(), node, "Must be a valid parameter class"));
        }
    }
}

