/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MetadataNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.stmt.Statement;
import org.objectweb.asm.Constants;

public class MethodNode
extends MetadataNode
implements Constants {
    private String name;
    private int modifiers;
    private String returnType;
    private Parameter[] parameters;
    private Statement code;
    private boolean dynamicReturnType;
    private VariableScope variableScope;
    ClassNode declaringClass;

    public MethodNode(String name, int modifiers, String returnType, Parameter[] parameters, Statement code) {
        this.name = name;
        this.modifiers = modifiers;
        this.parameters = parameters;
        this.code = code;
        if (returnType == null || returnType.length() == 0) {
            this.returnType = "java.lang.Object";
            this.dynamicReturnType = true;
        } else {
            this.returnType = MethodNode.ensureJavaTypeNameSyntax(returnType);
        }
    }

    public String getTypeDescriptor() {
        StringBuffer buf = new StringBuffer();
        buf.append(MethodNode.ensureJavaTypeNameSyntax(this.returnType));
        buf.append(' ');
        buf.append(this.name);
        buf.append('(');
        for (int i = 0; i < this.parameters.length; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            Parameter param = this.parameters[i];
            buf.append(MethodNode.ensureJavaTypeNameSyntax(param.getType()));
        }
        buf.append(')');
        return buf.toString();
    }

    public static String ensureJavaTypeNameSyntax(String typename) {
        if (typename.charAt(0) == '[') {
            return MethodNode.ensureJavaTypeNameSyntax(typename.substring(1)) + "[]";
        }
        if (typename.length() == 1) {
            switch (typename.charAt(0)) {
                case 'B': {
                    return "byte";
                }
                case 'C': {
                    return "char";
                }
                case 'D': {
                    return "double";
                }
                case 'F': {
                    return "float";
                }
                case 'J': {
                    return "long";
                }
                case 'I': {
                    return "int";
                }
                case 'S': {
                    return "short";
                }
                case 'V': {
                    return "void";
                }
                case 'Z': {
                    return "boolean";
                }
            }
        }
        if (typename.endsWith(";")) {
            return typename.substring(1, typename.length() - 1);
        }
        return typename;
    }

    public boolean isVoidMethod() {
        return "void".equals(this.returnType);
    }

    public Statement getCode() {
        return this.code;
    }

    public void setCode(Statement code) {
        this.code = code;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public String getName() {
        return this.name;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public VariableScope getVariableScope() {
        return this.variableScope;
    }

    public void setVariableScope(VariableScope variableScope) {
        this.variableScope = variableScope;
    }

    public boolean isDynamicReturnType() {
        return this.dynamicReturnType;
    }

    public ClassNode getDeclaringClass() {
        return this.declaringClass;
    }

    public boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public String toString() {
        return super.toString() + "[name: " + this.name + "]";
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public void setDeclaringClass(ClassNode declaringClass) {
        this.declaringClass = declaringClass;
    }
}

