/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyRuntimeException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class GroovyClassLoader
extends SecureClassLoader {
    private Map cache = new HashMap();
    private CompilerConfiguration config;
    private String[] searchPaths;
    static /* synthetic */ Class class$groovy$lang$GroovyObject;

    public GroovyClassLoader() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public GroovyClassLoader(ClassLoader loader) {
        this(loader, new CompilerConfiguration());
    }

    public GroovyClassLoader(GroovyClassLoader parent) {
        this(parent, parent.config);
    }

    public GroovyClassLoader(ClassLoader loader, CompilerConfiguration config) {
        super(loader);
        this.config = config;
    }

    public Class defineClass(ClassNode classNode, String file) {
        return this.defineClass(classNode, file, "/groovy/defineClass");
    }

    public Class defineClass(ClassNode classNode, String file, String newCodeBase) {
        CodeSource codeSource = null;
        try {
            codeSource = new CodeSource(new URL("file", "", newCodeBase), (Certificate[])null);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        CompilationUnit unit = new CompilationUnit(this.config, codeSource, this.getParent());
        try {
            ClassCollector collector = this.createCollector(unit);
            unit.addClassNode(classNode);
            unit.setClassgenCallback(collector);
            unit.compile(7);
            return collector.generatedClass;
        }
        catch (CompilationFailedException e) {
            throw new RuntimeException(e);
        }
    }

    public Class parseClass(File file) throws CompilationFailedException, IOException {
        return this.parseClass(new GroovyCodeSource(file));
    }

    public Class parseClass(String text, String fileName) throws CompilationFailedException, IOException {
        return this.parseClass(new ByteArrayInputStream(text.getBytes()), fileName);
    }

    public Class parseClass(String text) throws CompilationFailedException, IOException {
        return this.parseClass(new ByteArrayInputStream(text.getBytes()), "script" + System.currentTimeMillis() + ".groovy");
    }

    public Class parseClass(InputStream in) throws CompilationFailedException, IOException {
        return this.parseClass(in, "script" + System.currentTimeMillis() + ".groovy");
    }

    public Class parseClass(final InputStream in, final String fileName) throws CompilationFailedException, IOException {
        GroovyCodeSource gcs = (GroovyCodeSource)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new GroovyCodeSource(in, fileName, "/groovy/script");
            }
        });
        return this.parseClass(gcs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class parseClass(GroovyCodeSource codeSource) throws CompilationFailedException, IOException {
        Map map;
        String name = codeSource.getName();
        Class answer = null;
        Map map2 = this.cache;
        synchronized (map2) {
            answer = (Class)this.cache.get(name);
            if (answer != null) {
                return answer == PARSING.class ? null : answer;
            }
            this.cache.put(name, PARSING.class);
        }
        try {
            CompilationUnit unit = new CompilationUnit(this.config, codeSource.getCodeSource(), this);
            ClassCollector collector = this.createCollector(unit);
            unit.addSource(name, codeSource.getInputStream());
            unit.setClassgenCallback(collector);
            unit.compile(7);
            answer = collector.generatedClass;
            Object var7_7 = null;
            map = this.cache;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            Map map3 = this.cache;
            synchronized (map3) {
                if (answer == null) {
                    this.cache.remove(name);
                } else {
                    this.cache.put(name, answer);
                }
            }
            throw throwable;
        }
        synchronized (map) {
            if (answer == null) {
                this.cache.remove(name);
            } else {
                this.cache.put(name, answer);
            }
        }
        return answer;
    }

    protected Class findClass(final String name) throws ClassNotFoundException {
        String className;
        int i;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && (i = (className = name.replace('/', '.')).lastIndexOf(46)) != -1) {
            sm.checkPackageDefinition(className.substring(0, i));
        }
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return GroovyClassLoader.this.findGroovyClass(name);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (ClassNotFoundException)pae.getException();
        }
    }

    protected Class findGroovyClass(String name) throws ClassNotFoundException {
        String filename = name.replace('.', '/') + ".groovy";
        String[] paths = this.getClassPath();
        File classnameAsFile = new File(filename);
        String classname = classnameAsFile.getName();
        String pkg = classnameAsFile.getParent();
        for (int i = 0; i < paths.length; ++i) {
            String pathName = paths[i];
            File path = new File(pathName);
            if (!path.exists()) continue;
            if (path.isDirectory()) {
                String pkgdir;
                File pkgdirF;
                File nocasefile = new File(path, filename);
                if (!nocasefile.exists() || !(pkgdirF = new File(pkgdir = pkg == null ? pathName : pathName + "/" + pkg)).exists() || !pkgdirF.isDirectory()) continue;
                File[] files = pkgdirF.listFiles();
                for (int j = 0; j < files.length; ++j) {
                    if (!files[j].getName().equals(classname)) continue;
                    try {
                        return this.parseClass(files[j]);
                    }
                    catch (CompilationFailedException e) {
                        e.printStackTrace();
                        throw new ClassNotFoundException("Syntax error in groovy file: " + files[j].getAbsolutePath(), e);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new ClassNotFoundException("Error reading groovy file: " + files[j].getAbsolutePath(), e);
                    }
                }
                continue;
            }
            try {
                JarFile jarFile = new JarFile(path);
                JarEntry entry = jarFile.getJarEntry(filename);
                if (entry == null) continue;
                byte[] bytes = this.extractBytes(jarFile, entry);
                Certificate[] certs = entry.getCertificates();
                try {
                    return this.parseClass(new GroovyCodeSource(new ByteArrayInputStream(bytes), filename, path, certs));
                }
                catch (CompilationFailedException e1) {
                    e1.printStackTrace();
                    throw new ClassNotFoundException("Syntax error in groovy file: " + filename, e1);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    throw new ClassNotFoundException("Error reading groovy file: " + filename, e1);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(name);
    }

    private byte[] extractBytes(JarFile jarFile, JarEntry entry) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int b;
            BufferedInputStream bis = new BufferedInputStream(jarFile.getInputStream(entry));
            while ((b = bis.read()) != -1) {
                baos.write(b);
            }
        }
        catch (IOException ioe) {
            throw new GroovyRuntimeException("Could not read the jar bytes for " + entry.getName());
        }
        return baos.toByteArray();
    }

    protected String[] getClassPath() {
        if (this.searchPaths == null) {
            ArrayList pathList = new ArrayList();
            String classpath = System.getProperty("java.class.path", ".");
            this.expandClassPath(pathList, null, classpath);
            this.searchPaths = new String[pathList.size()];
            this.searchPaths = pathList.toArray(this.searchPaths);
        }
        return this.searchPaths;
    }

    protected void expandClassPath(List pathList, String base, String classpath) {
        if (classpath != null) {
            String[] paths = classpath.split("[\\ ,:;]");
            for (int i = 0; i < paths.length; ++i) {
                if (paths.length <= 0) continue;
                File path = null;
                path = "".equals(base) ? new File(paths[i]) : new File(base, paths[i]);
                if (!path.exists()) continue;
                if (!path.isDirectory()) {
                    try {
                        Attributes classPathAttributes;
                        String manifestClassPath;
                        JarFile jar = new JarFile(path);
                        pathList.add(paths[i]);
                        Manifest manifest = jar.getManifest();
                        if (manifest == null || (manifestClassPath = (classPathAttributes = manifest.getMainAttributes()).getValue("Class-Path")) == null) continue;
                        this.expandClassPath(pathList, paths[i], manifestClassPath);
                    }
                    catch (IOException e) {}
                    continue;
                }
                pathList.add(paths[i]);
            }
        }
    }

    protected Class defineClass(String name, byte[] bytecode, ProtectionDomain domain) {
        return this.defineClass(name, bytecode, 0, bytecode.length, domain);
    }

    protected ClassCollector createCollector(CompilationUnit unit) {
        return new ClassCollector(this, unit);
    }

    public Class defineClass(String name, byte[] b) {
        return super.defineClass(name, b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Class loadClass(final String name, boolean resolve) throws ClassNotFoundException {
        Class cls;
        String className;
        int i;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && (i = (className = name.replace('/', '.')).lastIndexOf(46)) != -1) {
            sm.checkPackageAccess(className.substring(0, i));
        }
        if (this.getTimeStamp(cls = super.loadClass(name, resolve)) < Long.MAX_VALUE) {
            Class<?>[] inters = cls.getInterfaces();
            boolean isGroovyObject = false;
            for (int i2 = 0; i2 < inters.length; ++i2) {
                if (!inters[i2].getName().equals((class$groovy$lang$GroovyObject == null ? GroovyClassLoader.class$("groovy.lang.GroovyObject") : class$groovy$lang$GroovyObject).getName())) continue;
                isGroovyObject = true;
                break;
            }
            if (isGroovyObject) {
                try {
                    File source = (File)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return GroovyClassLoader.this.getSourceFile(name);
                        }
                    });
                    if (source != null && cls != null && this.isSourceNewer(source, cls)) {
                        cls = this.parseClass(source);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Map map = this.cache;
                    synchronized (map) {
                        this.cache.put(name, NOT_RESOLVED.class);
                    }
                    throw new ClassNotFoundException("Failed to parse groovy file: " + name, e);
                }
            }
        }
        return cls;
    }

    private long getTimeStamp(Class cls) {
        Long o;
        try {
            Field field = cls.getField("__timeStamp");
            o = (Long)field.get(null);
        }
        catch (Exception e) {
            return Long.MAX_VALUE;
        }
        return o;
    }

    private File getSourceFile(String name) {
        File source = null;
        String filename = name.replace('.', '/') + ".groovy";
        String[] paths = this.getClassPath();
        for (int i = 0; i < paths.length; ++i) {
            File file;
            String pathName = paths[i];
            File path = new File(pathName);
            if (!path.exists() || !path.isDirectory() || !(file = new File(path, filename)).exists()) continue;
            boolean fileExists = false;
            int sepp = filename.lastIndexOf(47);
            String fn = filename;
            if (sepp >= 0) {
                fn = filename.substring(++sepp);
            }
            File parent = file.getParentFile();
            String[] files = parent.list();
            for (int j = 0; j < files.length; ++j) {
                if (!files[j].equals(fn)) continue;
                fileExists = true;
                break;
            }
            if (!fileExists) continue;
            source = file;
            break;
        }
        return source;
    }

    private boolean isSourceNewer(File source, Class cls) {
        return source.lastModified() > this.getTimeStamp(cls);
    }

    public static class ClassCollector
    extends CompilationUnit.ClassgenCallback {
        private Class generatedClass;
        private GroovyClassLoader cl;
        private CompilationUnit unit;

        protected ClassCollector(GroovyClassLoader cl, CompilationUnit unit) {
            this.cl = cl;
            this.unit = unit;
        }

        protected Class onClassNode(ClassWriter classWriter, ClassNode classNode) {
            byte[] code = classWriter.toByteArray();
            Class theClass = this.cl.defineClass(classNode.getName(), code, 0, code.length, this.unit.getAST().getCodeSource());
            if (this.generatedClass == null) {
                this.generatedClass = theClass;
            }
            return theClass;
        }

        public void call(ClassVisitor classWriter, ClassNode classNode) {
            this.onClassNode((ClassWriter)classWriter, classNode);
        }
    }

    private class NOT_RESOLVED {
        private NOT_RESOLVED() {
        }
    }

    private class PARSING {
        private PARSING() {
        }
    }
}

