/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.lang.Closure;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyShell;
import java.io.File;
import java.io.PrintWriter;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;

public class GroovyTestCase
extends TestCase {
    protected Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private static int counter;
    private boolean useAgileDoxNaming = false;

    public String getName() {
        if (this.useAgileDoxNaming) {
            return super.getName().substring(4).replaceAll("([A-Z])", " $1").toLowerCase();
        }
        return super.getName();
    }

    public String getMethodName() {
        return super.getName();
    }

    protected void assertArrayEquals(Object[] expected, Object[] value) {
        String message = "expected array: " + InvokerHelper.toString(expected) + " value array: " + InvokerHelper.toString(value);
        GroovyTestCase.assertNotNull((String)(message + ": expected should not be null"), (Object)value);
        GroovyTestCase.assertNotNull((String)(message + ": value should not be null"), (Object)value);
        GroovyTestCase.assertEquals((String)message, (int)expected.length, (int)value.length);
        int size = expected.length;
        for (int i = 0; i < size; ++i) {
            GroovyTestCase.assertEquals((String)("value[" + i + "] when " + message), (Object)expected[i], (Object)value[i]);
        }
    }

    protected void assertLength(int length, char[] array) {
        GroovyTestCase.assertEquals((int)length, (int)array.length);
    }

    protected void assertLength(int length, int[] array) {
        GroovyTestCase.assertEquals((int)length, (int)array.length);
    }

    protected void assertLength(int length, Object[] array) {
        GroovyTestCase.assertEquals((int)length, (int)array.length);
    }

    protected void assertContains(char expected, char[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != expected) continue;
            return;
        }
        StringBuffer message = new StringBuffer();
        message.append(expected + " not in {");
        for (int i = 0; i < array.length; ++i) {
            message.append("'" + array[i] + "'");
            if (i >= array.length - 1) continue;
            message.append(", ");
        }
        message.append(" }");
        GroovyTestCase.fail((String)message.toString());
    }

    protected void assertContains(int expected, int[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != expected) continue;
            return;
        }
        StringBuffer message = new StringBuffer();
        message.append(expected + " not in {");
        for (int i = 0; i < array.length; ++i) {
            message.append("'" + array[i] + "'");
            if (i >= array.length - 1) continue;
            message.append(", ");
        }
        message.append(" }");
        GroovyTestCase.fail((String)message.toString());
    }

    protected void assertToString(Object value, String expected) {
        Object console = InvokerHelper.invokeMethod(value, "toString", null);
        GroovyTestCase.assertEquals((String)("toString() on value: " + value), (Object)expected, (Object)console);
    }

    protected void assertInspect(Object value, String expected) {
        Object console = InvokerHelper.invokeMethod(value, "inspect", null);
        GroovyTestCase.assertEquals((String)("inspect() on value: " + value), (Object)expected, (Object)console);
    }

    protected void assertScript(final String script) throws Exception {
        this.log.info("About to execute script");
        String testClassName = this.getTestClassName();
        File file = new File("target/test-classes/" + testClassName);
        this.log.info("Creating file " + file);
        DefaultGroovyMethods.withPrintWriter(file, new Closure(null){

            protected void doCall(PrintWriter writer) {
                writer.println(script);
            }
        });
        GroovyShell shell = new GroovyShell();
        shell.evaluate(new GroovyCodeSource(file));
    }

    protected String getTestClassName() {
        return "TestScript" + this.getMethodName() + counter++ + ".groovy";
    }

    protected void shouldFail(Closure code) {
        boolean failed = false;
        try {
            code.call();
        }
        catch (Exception e) {
            failed = true;
            System.out.println("Worked: caught expected exception: " + e);
        }
        GroovyTestCase.assertTrue((String)("Closure " + code + " should have failed"), (boolean)failed);
    }

    protected void shouldFail(Class clazz, Closure code) {
        boolean failed;
        block2: {
            failed = false;
            try {
                code.call();
            }
            catch (Exception e) {
                if (!clazz.isInstance(e)) break block2;
                failed = true;
                System.out.println("Worked: caught expected exception: " + e);
            }
        }
        GroovyTestCase.assertTrue((String)("Closure " + code + " should have failed with an exception of type " + clazz.getName()), (boolean)failed);
    }

    protected String fixEOLs(String value) {
        return value.replaceAll("(\\r\\n?)|\n", "\n");
    }
}

