/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.myfaces.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageUtils {
    private static final Log log = LogFactory.getLog((Class)(class$net$sourceforge$myfaces$util$MessageUtils == null ? (class$net$sourceforge$myfaces$util$MessageUtils = MessageUtils.class$("net.sourceforge.myfaces.util.MessageUtils")) : class$net$sourceforge$myfaces$util$MessageUtils));
    private static final String DEFAULT_BUNDLE = "javax.faces.Messages";
    private static final String DETAIL_SUFFIX = "_detail";
    static /* synthetic */ Class class$net$sourceforge$myfaces$util$MessageUtils;
    static /* synthetic */ Class class$javax$faces$context$FacesContext;

    public static FacesMessage getMessage(FacesMessage.Severity severity, String messageId, Object arg1) {
        return MessageUtils.getMessage(severity, messageId, new Object[]{arg1}, FacesContext.getCurrentInstance());
    }

    public static FacesMessage getMessage(FacesMessage.Severity severity, String messageId, Object[] args) {
        return MessageUtils.getMessage(severity, messageId, args, FacesContext.getCurrentInstance());
    }

    public static FacesMessage getMessage(FacesMessage.Severity severity, String messageId, Object[] args, FacesContext facesContext) {
        Locale locale = facesContext.getViewRoot() != null ? facesContext.getViewRoot().getLocale() : facesContext.getApplication().getDefaultLocale();
        return MessageUtils.internalGetMessage(facesContext, locale, severity, messageId, args);
    }

    public static void addMessage(FacesMessage.Severity severity, String messageId, Object[] args) {
        MessageUtils.addMessage(severity, messageId, args, null, FacesContext.getCurrentInstance());
    }

    public static void addMessage(FacesMessage.Severity severity, String messageId, Object[] args, FacesContext facesContext) {
        MessageUtils.addMessage(severity, messageId, args, null, facesContext);
    }

    public static void addMessage(FacesMessage.Severity severity, String messageId, Object[] args, String forClientId) {
        MessageUtils.addMessage(severity, messageId, args, forClientId, FacesContext.getCurrentInstance());
    }

    public static void addMessage(FacesMessage.Severity severity, String messageId, Object[] args, String forClientId, FacesContext facesContext) {
        facesContext.addMessage(forClientId, MessageUtils.getMessage(severity, messageId, args, facesContext));
    }

    private static FacesMessage internalGetMessage(FacesContext facesContext, Locale locale, FacesMessage.Severity severity, String messageId, Object[] args) {
        String detail;
        ResourceBundle appBundle = MessageUtils.getApplicationBundle(facesContext, locale);
        String summary = MessageUtils.getBundleString(appBundle, messageId);
        if (summary != null) {
            detail = MessageUtils.getBundleString(appBundle, messageId + DETAIL_SUFFIX);
        } else {
            ResourceBundle defBundle = MessageUtils.getDefaultBundle(locale);
            summary = MessageUtils.getBundleString(defBundle, messageId);
            if (summary != null) {
                detail = MessageUtils.getBundleString(defBundle, messageId + DETAIL_SUFFIX);
            } else {
                detail = MessageUtils.getBundleString(appBundle, messageId + DETAIL_SUFFIX);
                if (detail != null) {
                    summary = null;
                } else {
                    detail = MessageUtils.getBundleString(defBundle, messageId + DETAIL_SUFFIX);
                    if (detail != null) {
                        summary = null;
                    } else {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)("No message with id " + messageId + " found in any bundle"));
                        }
                        return new FacesMessage(severity, messageId, null);
                    }
                }
            }
        }
        if (args != null && args.length > 0) {
            MessageFormat format;
            if (summary != null) {
                format = new MessageFormat(summary, locale);
                summary = format.format(args);
            }
            if (detail != null) {
                format = new MessageFormat(detail, locale);
                detail = format.format(args);
            }
        }
        return new FacesMessage(severity, summary, detail);
    }

    private static String getBundleString(ResourceBundle bundle, String key) {
        try {
            return bundle == null ? null : bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private static ResourceBundle getApplicationBundle(FacesContext facesContext, Locale locale) {
        String bundleName = facesContext.getApplication().getMessageBundle();
        if (bundleName != null) {
            try {
                return ResourceBundle.getBundle(bundleName, locale, Thread.currentThread().getContextClassLoader());
            }
            catch (MissingResourceException e) {
                log.error((Object)("Resource bundle " + bundleName + " could not be found."));
                return null;
            }
        }
        return null;
    }

    private static ResourceBundle getDefaultBundle(Locale locale) {
        try {
            return ResourceBundle.getBundle(DEFAULT_BUNDLE, locale, (class$javax$faces$context$FacesContext == null ? (class$javax$faces$context$FacesContext = MessageUtils.class$("javax.faces.context.FacesContext")) : class$javax$faces$context$FacesContext).getClassLoader());
        }
        catch (MissingResourceException e) {
            log.error((Object)"Resource bundle javax.faces.Messages could not be found.");
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

