/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.myfaces.context.servlet;

import java.util.Enumeration;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.myfaces.context.servlet.AbstractAttributeMap;

public class CookieMap
extends AbstractAttributeMap {
    final HttpServletRequest _httpServletRequest;

    CookieMap(HttpServletRequest httpServletRequest) {
        this._httpServletRequest = httpServletRequest;
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot clear HttpRequest Cookies");
    }

    public boolean containsKey(Object key) {
        Cookie[] cookies = this._httpServletRequest.getCookies();
        int len = cookies.length;
        for (int i = 0; i < len; ++i) {
            if (!cookies[i].getName().equals(key)) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(Object findValue) {
        if (findValue == null) {
            return false;
        }
        Cookie[] cookies = this._httpServletRequest.getCookies();
        int len = cookies.length;
        for (int i = 0; i < len; ++i) {
            if (!findValue.equals(cookies[i].getValue())) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this._httpServletRequest.getCookies().length == 0;
    }

    public int size() {
        return this._httpServletRequest.getCookies().length;
    }

    protected Object getAttribute(String key) {
        Cookie[] cookies = this._httpServletRequest.getCookies();
        int len = cookies.length;
        for (int i = 0; i < len; ++i) {
            if (!cookies[i].getName().equals(key)) continue;
            return cookies[i].getValue();
        }
        return null;
    }

    protected void setAttribute(String key, Object value) {
        throw new UnsupportedOperationException("Cannot set HttpRequest Cookies");
    }

    protected void removeAttribute(String key) {
        throw new UnsupportedOperationException("Cannot remove HttpRequest Cookies");
    }

    protected Enumeration getAttributeNames() {
        return new CookieNameEnumeration(this._httpServletRequest.getCookies());
    }

    private static class CookieNameEnumeration
    implements Enumeration {
        private final Cookie[] _cookies;
        private final int _length;
        private int _index;

        public CookieNameEnumeration(Cookie[] cookies) {
            this._cookies = cookies;
            this._length = cookies.length;
        }

        public boolean hasMoreElements() {
            return this._index < this._length;
        }

        public Object nextElement() {
            return this._cookies[this._index++].getName();
        }
    }
}

