/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.util;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.seasar.framework.container.S2Container;

public class BindingUtil {
    private BindingUtil() {
    }

    public static Object getValue(S2Container container, String name) {
        HttpServletRequest request = container.getRequest();
        Object var = request.getParameter(name);
        if (var != null) {
            return var;
        }
        var = request.getAttribute(name);
        if (var != null) {
            return var;
        }
        HttpSession session = request.getSession(false);
        if (session != null && (var = session.getAttribute(name)) != null) {
            return var;
        }
        if (container.hasComponentDef((Object)name)) {
            return container.getComponent((Object)name);
        }
        return null;
    }

    public static Object getBindingValue(UIComponent component, String propertyName) {
        ValueBinding binding = component.getValueBinding(propertyName);
        if (binding != null) {
            FacesContext ctx = FacesContext.getCurrentInstance();
            return binding.getValue(ctx);
        }
        return null;
    }

    public static String getValueReference(String value) {
        return "#{" + value + "}";
    }

    public static boolean isValueReference(String value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        return value.startsWith("#{") && value.endsWith("}");
    }

    public static String removeBinding(String valueReference) {
        return valueReference.substring(2, valueReference.length() - 1);
    }
}

