/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.template.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.cyberneko.html.parsers.DOMParser;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.exception.SAXRuntimeException;
import org.seasar.jsf.template.ComponentFactory;
import org.seasar.jsf.template.NodeHandler;
import org.seasar.jsf.template.ViewTemplate;
import org.seasar.jsf.template.ViewTemplateFactory;
import org.seasar.jsf.template.impl.ViewTemplateImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ViewTemplateFactoryImpl
implements ViewTemplateFactory {
    private S2Container container_;
    private String viewExtension_ = "html";
    private String encoding_ = "Shift_JIS";
    private List nodeHandlers_ = new ArrayList();
    private Map viewTemplates_ = new HashMap();

    public String getViewExtension() {
        return this.viewExtension_;
    }

    public void setViewExtension(String viewExtension) {
        this.viewExtension_ = viewExtension;
    }

    public String getEncoding() {
        return this.encoding_;
    }

    public void setEncoding(String encoding) {
        this.encoding_ = encoding;
    }

    public ViewTemplate getViewTemplate(String viewId) {
        ViewTemplate template = (ViewTemplate)this.viewTemplates_.get(viewId);
        if (template != null && !template.isModified()) {
            return template;
        }
        ServletContext ctx = this.container_.getRoot().getServletContext();
        DOMParser parser = this.createParser();
        String path = String.valueOf(viewId) + "." + this.viewExtension_;
        String realPath = ctx.getRealPath(path);
        try {
            parser.parse(new InputSource(ctx.getResourceAsStream(path)));
        }
        catch (SAXException ex) {
            throw new SAXRuntimeException(ex);
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
        Element rootElement = parser.getDocument().getDocumentElement();
        ComponentFactory root = this.buildComponentFactoryTree(rootElement);
        template = new ViewTemplateImpl(viewId, root, new File(realPath));
        this.viewTemplates_.put(viewId, template);
        return template;
    }

    protected ComponentFactory buildComponentFactoryTree(Node node) {
        ComponentFactory root = this.createComponentFactory(node);
        this.appendChildrenComponentFactory(root, node.getChildNodes());
        return root;
    }

    protected ComponentFactory createComponentFactory(Node node) {
        NodeHandler handler = this.getNodeHandler(node);
        if (handler != null) {
            return handler.createComponentFactory(node);
        }
        return null;
    }

    protected NodeHandler getNodeHandler(Node node) {
        int i = 0;
        while (i < this.nodeHandlers_.size()) {
            NodeHandler handler = (NodeHandler)this.nodeHandlers_.get(i);
            if (handler.isHandleable(node)) {
                return handler;
            }
            ++i;
        }
        return null;
    }

    protected void appendChildrenComponentFactory(ComponentFactory parent, NodeList childrenNode) {
        int i = 0;
        while (i < childrenNode.getLength()) {
            Node n = childrenNode.item(i);
            this.appendChildComponentFactory(parent, n);
            ++i;
        }
    }

    protected void appendChildComponentFactory(ComponentFactory parent, Node childNode) {
        ComponentFactory child = this.createComponentFactory(childNode);
        if (child != null) {
            parent.addChild(child);
            this.appendChildrenComponentFactory(child, childNode.getChildNodes());
        }
    }

    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    public void addNodeHandler(NodeHandler nodeHandler) {
        this.nodeHandlers_.add(nodeHandler);
    }

    protected DOMParser createParser() {
        DOMParser parser = new DOMParser();
        try {
            parser.setProperty("http://cyberneko.org/html/properties/default-encoding", (Object)this.encoding_);
            parser.setProperty("http://cyberneko.org/html/properties/names/attrs", (Object)"default");
            parser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"match");
        }
        catch (SAXException ex) {
            throw new SAXRuntimeException(ex);
        }
        return parser;
    }
}

