/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.template.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.StringUtil;
import org.seasar.jsf.template.ComponentFactory;
import org.seasar.jsf.util.BindingUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class AbstractComponentFactory
implements ComponentFactory {
    private Node node_;
    private List children_ = new ArrayList();
    private Map properties_ = new HashMap();
    private Set customPropertyNames_ = new HashSet();

    public AbstractComponentFactory(Node node) {
        this.node_ = node;
        this.setupProperties();
        this.renameProperties();
    }

    protected Node getNode() {
        return this.node_;
    }

    public int getChildCount() {
        return this.children_.size();
    }

    public ComponentFactory getChild(int index) {
        return (ComponentFactory)this.children_.get(index);
    }

    public void addChild(ComponentFactory componentFactory) {
        this.children_.add(componentFactory);
    }

    protected Map getProperties() {
        return this.properties_;
    }

    protected Object getProperty(String propertyName) {
        return this.properties_.get(propertyName);
    }

    protected void setupProperties() {
        NamedNodeMap nnm = this.node_.getAttributes();
        if (nnm == null) {
            return;
        }
        int length = nnm.getLength();
        int i = 0;
        while (i < length) {
            Attr attr = (Attr)nnm.item(i);
            if ("http://www.seasar.org/jsf/binding".equals(attr.getNamespaceURI())) {
                this.properties_.put(attr.getLocalName(), BindingUtil.getValueReference(attr.getValue()));
            } else if (this.properties_.get(attr.getName()) == null) {
                this.properties_.put(attr.getName(), attr.getValue());
            }
            ++i;
        }
    }

    protected void renameProperties() {
        this.renameProperty("class", "styleClass");
    }

    protected void renameProperty(String from, String to) {
        if (this.properties_.containsKey(from)) {
            Object value = this.properties_.remove(from);
            this.properties_.put(to, value);
        }
    }

    protected void addCustomPropertyName(String propertyName) {
        this.customPropertyNames_.add(propertyName);
    }

    protected boolean isCustomProperty(String propertyName) {
        return this.customPropertyNames_.contains(propertyName);
    }

    protected void setProperties(UIComponent component) {
        ArrayList<String> bindingPropertyNames = new ArrayList<String>();
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(component.getClass());
        Iterator i = this.properties_.keySet().iterator();
        while (i.hasNext()) {
            String propertyName = (String)i.next();
            Object value = this.properties_.get(propertyName);
            String s = (String)value;
            if (StringUtil.isEmpty((String)s) || this.isCustomProperty(s)) continue;
            if (BindingUtil.isValueReference(s)) {
                FacesContext ctx = FacesContext.getCurrentInstance();
                Application app = ctx.getApplication();
                ValueBinding binding = app.createValueBinding(s);
                component.setValueBinding(propertyName, binding);
                bindingPropertyNames.add(propertyName);
                continue;
            }
            if (beanDesc.hasPropertyDesc(propertyName)) {
                PropertyDesc pd = beanDesc.getPropertyDesc(propertyName);
                value = pd.convertIfNeed(value);
            }
            component.getAttributes().put(propertyName, value);
        }
        component.getAttributes().put("_BINDING_PROPERTY_NAMES_", bindingPropertyNames);
    }
}

