/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.application;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.jsf.template.ViewTemplate;
import org.seasar.jsf.template.ViewTemplateFactory;

public class S2ViewHandler
extends ViewHandler {
    private static final String STATE_KEY = "org.seasar.jsf.viewState";
    private ViewHandler originalViewHandler_;
    private ViewTemplateFactory viewTemplateFactory_;
    static /* synthetic */ Class class$0;

    public S2ViewHandler(ViewHandler originalViewHandler) {
        this.originalViewHandler_ = originalViewHandler;
    }

    public ViewTemplateFactory getViewTemplateFactory() {
        if (this.viewTemplateFactory_ != null) {
            return this.viewTemplateFactory_;
        }
        S2Container container = SingletonS2ContainerFactory.getContainer();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.jsf.template.ViewTemplateFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.viewTemplateFactory_ = (ViewTemplateFactory)container.getComponent((Object)clazz);
        return this.viewTemplateFactory_;
    }

    public Locale calculateLocale(FacesContext context) {
        return this.originalViewHandler_.calculateLocale(context);
    }

    public String calculateRenderKitId(FacesContext context) {
        return this.originalViewHandler_.calculateRenderKitId(context);
    }

    public String getActionURL(FacesContext context, String viewId) {
        return this.originalViewHandler_.getActionURL(context, viewId);
    }

    public String getResourceURL(FacesContext context, String path) {
        return this.originalViewHandler_.getResourceURL(context, path);
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        String realViewId = ResourceUtil.removeExtension((String)viewId);
        ViewTemplate template = this.getViewTemplateFactory().getViewTemplate(realViewId);
        UIViewRoot viewRoot = template.createView();
        if (viewRoot != null) {
            if (context.getViewRoot() != null) {
                UIViewRoot oldViewRoot = context.getViewRoot();
                viewRoot.setLocale(oldViewRoot.getLocale());
                viewRoot.setRenderKitId(oldViewRoot.getRenderKitId());
            } else {
                viewRoot.setLocale(this.calculateLocale(context));
                viewRoot.setRenderKitId(this.calculateRenderKitId(context));
            }
        }
        return viewRoot;
    }

    public void renderView(FacesContext context, UIViewRoot viewRoot) throws IOException {
        this.setupResponseWriter(context);
        StateManager sm = context.getApplication().getStateManager();
        StateManager.SerializedView state = sm.saveSerializedView(context);
        context.getExternalContext().getRequestMap().put(STATE_KEY, state);
        context.getResponseWriter().startDocument();
        this.renderResponse(context, (UIComponent)viewRoot);
        context.getResponseWriter().endDocument();
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        String realViewId = ResourceUtil.removeExtension((String)viewId);
        String renderKitId = context.getApplication().getViewHandler().calculateRenderKitId(context);
        StateManager sm = context.getApplication().getStateManager();
        return sm.restoreView(context, realViewId, renderKitId);
    }

    public void writeState(FacesContext context) throws IOException {
        StateManager.SerializedView state = (StateManager.SerializedView)context.getExternalContext().getRequestMap().get(STATE_KEY);
        if (state != null) {
            StateManager sm = context.getApplication().getStateManager();
            sm.writeState(context, state);
        }
    }

    protected void renderResponse(FacesContext context, UIComponent component) throws IOException {
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            Iterator i = component.getChildren().iterator();
            while (i.hasNext()) {
                this.renderResponse(context, (UIComponent)i.next());
            }
        }
        component.encodeEnd(context);
    }

    protected void setupResponseWriter(FacesContext context) throws IOException {
        ServletResponse response = (ServletResponse)context.getExternalContext().getResponse();
        ServletOutputStream os = response.getOutputStream();
        Map headers = context.getExternalContext().getRequestHeaderMap();
        String acceptHeader = (String)headers.get("Accept");
        if (acceptHeader != null && (acceptHeader.indexOf("*/*") != -1 || acceptHeader.indexOf("text/*") != -1)) {
            acceptHeader = String.valueOf(acceptHeader) + ",text/html";
        }
        RenderKitFactory renderFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = renderFactory.getRenderKit(context, context.getViewRoot().getRenderKitId());
        ResponseWriter writer = renderKit.createResponseWriter((Writer)new OutputStreamWriter((OutputStream)os), acceptHeader, response.getCharacterEncoding());
        context.setResponseWriter(writer);
        response.setContentType(writer.getContentType());
    }
}

