/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.beans.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.ConstructorNotFoundRuntimeException;
import org.seasar.framework.beans.FieldNotFoundRuntimeException;
import org.seasar.framework.beans.MethodNotFoundRuntimeException;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.PropertyNotFoundRuntimeException;
import org.seasar.framework.beans.impl.PropertyDescImpl;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.util.ArrayMap;
import org.seasar.framework.util.CaseInsensitiveMap;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ConstructorUtil;
import org.seasar.framework.util.DoubleConversionUtil;
import org.seasar.framework.util.IntegerConversionUtil;
import org.seasar.framework.util.LongConversionUtil;
import org.seasar.framework.util.MethodUtil;
import org.seasar.framework.util.StringUtil;

public final class BeanDescImpl
implements BeanDesc {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private Class beanClass_;
    private Constructor[] constructors_;
    private CaseInsensitiveMap propertyDescCache_ = new CaseInsensitiveMap();
    private Map methodsCache_ = new HashMap();
    private Map fieldCache_ = new CaseInsensitiveMap();
    private transient Set invalidPropertyNames_ = new HashSet();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public BeanDescImpl(Class beanClass) throws EmptyRuntimeException {
        if (beanClass == null) {
            throw new EmptyRuntimeException("beanClass");
        }
        this.beanClass_ = beanClass;
        this.constructors_ = beanClass.getConstructors();
        this.setupPropertyDescs();
        this.setupMethods();
        this.setupField();
    }

    public Class getBeanClass() {
        return this.beanClass_;
    }

    public boolean hasPropertyDesc(String propertyName) {
        return this.propertyDescCache_.get(propertyName) != null;
    }

    public PropertyDesc getPropertyDesc(String propertyName) throws PropertyNotFoundRuntimeException {
        PropertyDesc pd = (PropertyDesc)this.propertyDescCache_.get(propertyName);
        if (pd == null) {
            throw new PropertyNotFoundRuntimeException(this.beanClass_, propertyName);
        }
        return pd;
    }

    private PropertyDesc getPropertyDesc0(String propertyName) {
        return (PropertyDesc)this.propertyDescCache_.get(propertyName);
    }

    public PropertyDesc getPropertyDesc(int index) {
        return (PropertyDesc)this.propertyDescCache_.get(index);
    }

    public int getPropertyDescSize() {
        return this.propertyDescCache_.size();
    }

    public boolean hasField(String fieldName) {
        return this.fieldCache_.get(fieldName) != null;
    }

    public Field getField(String fieldName) {
        Field field = (Field)this.fieldCache_.get(fieldName);
        if (field == null) {
            throw new FieldNotFoundRuntimeException(this.beanClass_, fieldName);
        }
        return field;
    }

    public Object newInstance(Object[] args) throws ConstructorNotFoundRuntimeException {
        Constructor constructor = this.getSuitableConstructor(args);
        return ConstructorUtil.newInstance(constructor, args);
    }

    public Object invoke(Object target, String methodName, Object[] args) {
        Method method = this.getSuitableMethod(methodName, args);
        return MethodUtil.invoke(method, target, args);
    }

    public Constructor getSuitableConstructor(Object[] args) throws ConstructorNotFoundRuntimeException {
        Constructor constructor;
        if (args == null) {
            args = EMPTY_ARGS;
        }
        if ((constructor = this.findSuitableConstructor(args)) != null) {
            return constructor;
        }
        constructor = this.findSuitableConstructorAdjustNumber(args);
        if (constructor != null) {
            return constructor;
        }
        throw new ConstructorNotFoundRuntimeException(this.beanClass_, args);
    }

    public Method[] getMethods(String methodName) throws MethodNotFoundRuntimeException {
        Method[] methods = (Method[])this.methodsCache_.get(methodName);
        if (methods == null) {
            throw new MethodNotFoundRuntimeException(this.beanClass_, methodName, null);
        }
        return methods;
    }

    public boolean hasMethod(String methodName) {
        return this.methodsCache_.get(methodName) != null;
    }

    public String[] getMethodNames() {
        return this.methodsCache_.keySet().toArray(new String[this.methodsCache_.size()]);
    }

    private Constructor findSuitableConstructor(Object[] args) {
        int i = 0;
        while (i < this.constructors_.length) {
            block4: {
                Class<?>[] paramTypes = this.constructors_[i].getParameterTypes();
                if (paramTypes.length == args.length) {
                    int j = 0;
                    while (j < args.length) {
                        if (args[j] == null || ClassUtil.isAssignableFrom(paramTypes[j], args[j].getClass())) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    return this.constructors_[i];
                }
            }
            ++i;
        }
        return null;
    }

    private Constructor findSuitableConstructorAdjustNumber(Object[] args) {
        int i = 0;
        while (i < this.constructors_.length) {
            block4: {
                Class[] paramTypes = this.constructors_[i].getParameterTypes();
                if (paramTypes.length == args.length) {
                    int j = 0;
                    while (j < args.length) {
                        if (args[j] == null || ClassUtil.isAssignableFrom(paramTypes[j], args[j].getClass()) || BeanDescImpl.adjustNumber(paramTypes, args, j)) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    return this.constructors_[i];
                }
            }
            ++i;
        }
        return null;
    }

    private static boolean adjustNumber(Class[] paramTypes, Object[] args, int index) {
        if (paramTypes[index].isPrimitive()) {
            if (paramTypes[index] == Integer.TYPE) {
                args[index] = IntegerConversionUtil.toInteger(args[index]);
                return true;
            }
            if (paramTypes[index] == Double.TYPE) {
                args[index] = DoubleConversionUtil.toDouble(args[index]);
                return true;
            }
            if (paramTypes[index] == Long.TYPE) {
                args[index] = LongConversionUtil.toLong(args[index]);
                return true;
            }
        }
        return false;
    }

    private void setupPropertyDescs() {
        Method[] methods = this.beanClass_.getMethods();
        int i = 0;
        while (i < methods.length) {
            String propertyName;
            Method m = methods[i];
            String methodName = m.getName();
            if (methodName.startsWith("get")) {
                if (m.getParameterTypes().length == 0 && !methodName.equals("getClass")) {
                    propertyName = BeanDescImpl.decapitalizePropertyName(methodName.substring(3));
                    this.setupReadMethod(m, propertyName);
                }
            } else if (methodName.startsWith("is")) {
                if (m.getParameterTypes().length == 0 && m.getReturnType().equals(Boolean.TYPE)) {
                    propertyName = BeanDescImpl.decapitalizePropertyName(methodName.substring(2));
                    this.setupReadMethod(m, propertyName);
                }
            } else if (methodName.startsWith("set") && m.getParameterTypes().length == 1 && !methodName.equals("setClass")) {
                propertyName = BeanDescImpl.decapitalizePropertyName(methodName.substring(3));
                this.setupWriteMethod(m, propertyName);
            }
            ++i;
        }
        Iterator i2 = this.invalidPropertyNames_.iterator();
        while (i2.hasNext()) {
            this.propertyDescCache_.remove(i2.next());
        }
        this.invalidPropertyNames_.clear();
    }

    private static String decapitalizePropertyName(String name) {
        if (StringUtil.isEmpty(name)) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private void addPropertyDesc(PropertyDesc propertyDesc) throws EmptyRuntimeException {
        if (propertyDesc == null) {
            throw new EmptyRuntimeException("propertyDesc");
        }
        this.propertyDescCache_.put(propertyDesc.getPropertyName(), propertyDesc);
    }

    private void setupReadMethod(Method readMethod, String propertyName) {
        Class<?> propertyType = readMethod.getReturnType();
        PropertyDesc propDesc = this.getPropertyDesc0(propertyName);
        if (propDesc != null) {
            if (!propDesc.getPropertyType().equals(propertyType)) {
                this.invalidPropertyNames_.add(propertyName);
            } else {
                propDesc.setReadMethod(readMethod);
            }
        } else {
            propDesc = new PropertyDescImpl(propertyName, propertyType, readMethod, null, this);
            this.addPropertyDesc(propDesc);
        }
    }

    private void setupWriteMethod(Method writeMethod, String propertyName) {
        Class<?> propertyType = writeMethod.getParameterTypes()[0];
        PropertyDesc propDesc = this.getPropertyDesc0(propertyName);
        if (propDesc != null) {
            if (!propDesc.getPropertyType().equals(propertyType)) {
                this.invalidPropertyNames_.add(propertyName);
            } else {
                propDesc.setWriteMethod(writeMethod);
            }
        } else {
            propDesc = new PropertyDescImpl(propertyName, propertyType, null, writeMethod, this);
            this.addPropertyDesc(propDesc);
        }
    }

    private Method getSuitableMethod(String methodName, Object[] args) throws MethodNotFoundRuntimeException {
        Method[] methods;
        Method method;
        if (args == null) {
            args = EMPTY_ARGS;
        }
        if ((method = this.findSuitableMethod(methods = this.getMethods(methodName), args)) != null) {
            return method;
        }
        method = this.findSuitableMethodAdjustNumber(methods, args);
        if (method != null) {
            return method;
        }
        throw new MethodNotFoundRuntimeException(this.beanClass_, methodName, args);
    }

    private Method findSuitableMethod(Method[] methods, Object[] args) {
        int i = 0;
        while (i < methods.length) {
            block4: {
                Class<?>[] paramTypes = methods[i].getParameterTypes();
                if (paramTypes.length == args.length) {
                    int j = 0;
                    while (j < args.length) {
                        if (args[j] == null || ClassUtil.isAssignableFrom(paramTypes[j], args[j].getClass())) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    return methods[i];
                }
            }
            ++i;
        }
        return null;
    }

    private Method findSuitableMethodAdjustNumber(Method[] methods, Object[] args) {
        int i = 0;
        while (i < methods.length) {
            block4: {
                Class[] paramTypes = methods[i].getParameterTypes();
                if (paramTypes.length == args.length) {
                    int j = 0;
                    while (j < args.length) {
                        if (args[j] == null || ClassUtil.isAssignableFrom(paramTypes[j], args[j].getClass()) || BeanDescImpl.adjustNumber(paramTypes, args, j)) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    return methods[i];
                }
            }
            ++i;
        }
        return null;
    }

    private void setupMethods() {
        ArrayMap methodListMap = new ArrayMap();
        Method[] methods = this.beanClass_.getMethods();
        int i = 0;
        while (i < methods.length) {
            ArrayList<Method> list = (ArrayList<Method>)methodListMap.get(methods[i].getName());
            if (list == null) {
                list = new ArrayList<Method>();
                methodListMap.put(methods[i].getName(), list);
            }
            list.add(methods[i]);
            ++i;
        }
        i = 0;
        while (i < methodListMap.size()) {
            List methodList = (List)methodListMap.get(i);
            this.methodsCache_.put(methodListMap.getKey(i), methodList.toArray(new Method[methodList.size()]));
            ++i;
        }
    }

    private void setupField() {
        Field[] fields = this.beanClass_.getFields();
        int i = 0;
        while (i < fields.length) {
            if (Modifier.isStatic(fields[i].getModifiers())) {
                this.fieldCache_.put(fields[i].getName(), fields[i]);
            }
            ++i;
        }
    }
}

