package org.seasar.extension.unit;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.sql.DataSource;
import javax.transaction.TransactionManager;

import junit.framework.Assert;
import junit.framework.TestCase;

import org.seasar.extension.dataset.ColumnType;
import org.seasar.extension.dataset.DataReader;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.DataWriter;
import org.seasar.extension.dataset.impl.SqlDeleteTableWriter;
import org.seasar.extension.dataset.impl.SqlReloadReader;
import org.seasar.extension.dataset.impl.SqlReloadTableReader;
import org.seasar.extension.dataset.impl.SqlTableReader;
import org.seasar.extension.dataset.impl.SqlWriter;
import org.seasar.extension.dataset.impl.XlsReader;
import org.seasar.extension.dataset.impl.XlsWriter;
import org.seasar.extension.dataset.types.ColumnTypes;
import org.seasar.extension.jdbc.UpdateHandler;
import org.seasar.extension.jdbc.impl.BasicUpdateHandler;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ContainerConstants;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.exception.NoSuchMethodRuntimeException;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ConnectionUtil;
import org.seasar.framework.util.DataSourceUtil;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.FileOutputStreamUtil;
import org.seasar.framework.util.MethodUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;

/**
 * JUnitTestCasegAS2geXgyȂ߂̃NXłB
 * eeXg\bhsۂɂ́Aȉ̏ԂŏȂ܂B
 * eXg\bh֌W鏈܂̂ŁAłtestXxx()Ƃ
 * eXg\bhsƉ肵܂B
 * <ol>
 * <li>S2Container̃CX^X쐬܂B</li>
 * <li>setUp()s܂B</li>
 * <li>setUpXxxƂÕ\bhΎs܂B</li>
 * <li>S2Container܂B</li>
 * <li>"j2ee.dataSource"ƂÕf[^\[XRei擾܂B</li>
 * <li>setUpAfterContainerInit()s܂B</li>
 * <li>tB[hDIȂ܂B</li>
 * <li>testXxx()s܂B</li>
 * <li>tearDownBeforeContainerDestroy()s܂B</li>
 * <li>f[^\[XJ܂B</li>
 * <li>S2ContaineȑIȂ܂B</li>
 * <li>tearDownXxx()ƂÕ\bhΎs܂B</li>
 * <li>tearDown()s܂B</li>
 * </ol>
 *
 * eXg\bh̍Ō"Tx"ƕtƁAeXg\bh̎sO
 * gUNVJnAeXg\bh̏IɃgUNV
 * [obN܂B
 * DB̃R[hύX悤ȃeXg̏ꍇ́A̋@\𗘗pĂB
 *
 * @author higa
 * @see junit.framework.TestCase
 */
public class S2TestCase extends TestCase {

	private static final String DATASOURCE_NAME = "j2ee"
			+ ContainerConstants.NS_SEP + "dataSource";

	private S2Container container_;

	private DataSource dataSource_;

	private Connection connection_;

	private DatabaseMetaData dbMetaData_;

	private List bindedFields_;

	/**
	 * w肳ꂽOŃeXgP[X쐬܂B
	 *
	 * @param name eXgP[X̖O
	 */
	public S2TestCase(String name) {
		super(name);
	}

	/**
	 * eXgP[XۗLS2Rei擾܂B
	 *
	 * @return S2Rei
	 */
	public S2Container getContainer() {
		return container_;
	}

	/**
	 * R|[lgw肵S2ReiR|[lg擾܂B
	 * w肵OR|[lgo^ĂȂꍇnullԂ܂B
	 *
	 * @param componentName 擾R|[lg
	 * @return w肵OR|[lg
	 * @see org.seasar.framework.container.S2Container#getComponent(java.lang.Object)
	 */
	public Object getComponent(String componentName) {
		return container_.getComponent(componentName);
	}

	/**
	 * NXw肵S2ReiR|[lg擾܂B
	 * C^[tF[Xw肵ꍇ͂̃C^[tF[XĂ
	 * R|[lgANXw肵ꍇ͂̃NX̃NXe
	 * qNX̃R|[lg擾܂B
	 * w肵NX̃R|[lgo^ĂȂꍇnullԂ܂B
	 *
	 * @param componentClass 擾NX
	 * @return w肵NX̃R|[lg
	 * @see org.seasar.framework.container.S2Container#getComponent(java.lang.Object)
	 */
	public Object getComponent(Class componentClass) {
		return container_.getComponent(componentClass);
	}

	/**
	 * R|[lgw肵S2ReiR|[lg`擾܂B
	 *
	 * @param componentName 擾R|[lg
	 * @return w肵OR|[lg`
	 * @see org.seasar.framework.container.S2Container#getComponentDef(java.lang.Object)
	 */
	public ComponentDef getComponentDef(String componentName) {
		return container_.getComponentDef(componentName);
	}

	/**
	 * NXw肵S2ReiR|[lg`擾܂B
	 *
	 * @param componentClass 擾NX
	 * @return w肵NX̃R|[lg`
	 * @see org.seasar.framework.container.S2Container#getComponentDef(java.lang.Object)
	 */
	public ComponentDef getComponentDef(Class componentClass) {
		return container_.getComponentDef(componentClass);
	}

	/**
	 * NXS2ReiɃR|[lg`Ƃēo^܂B
	 *
	 * @param componentClass R|[lg̃NX
	 * @see org.seasar.framework.container.S2Container#register(java.lang.Class)
	 */
	public void register(Class componentClass) {
		container_.register(componentClass);
	}

	/**
	 * NXS2ReiɖOtR|[lg`Ƃēo^܂B
	 *
	 * @param componentClass R|[lg̃NX
	 * @param componentName R|[lg̖O
	 * @see org.seasar.framework.container.S2Container#register(java.lang.Class, java.lang.String)
	 */
	public void register(Class componentClass, String componentName) {
		container_.register(componentClass, componentName);
	}

	/**
	 * IuWFNgS2ReiɃR|[lgƂēo^܂B
	 * L[̓IuWFNg̃NXɂȂ܂B
	 *
	 * @param component R|[lgƂēo^IuWFNg
	 * @see org.seasar.framework.container.S2Container#register(java.lang.Object)
	 */
	public void register(Object component) {
		container_.register(component);
	}

	/**
	 * IuWFNgS2ReiɖOtR|[lgƂēo^܂B
	 *
	 * @param component R|[lgƂēo^IuWFNg
	 * @param componentName R|[lg
	 * @see org.seasar.framework.container.S2Container#register(java.lang.Object, java.lang.String)
	 */
	public void register(Object component, String componentName) {
		container_.register(component, componentName);
	}

	/**
	 * S2ReiɃR|[lg`o^܂B
	 *
	 * @param componentDef o^R|[lg`
	 * @see org.seasar.framework.container.S2Container#register(org.seasar.framework.container.ComponentDef)
	 */
	public void register(ComponentDef componentDef) {
		container_.register(componentDef);
	}

	/**
	 * ݒt@C̃pXw肵ĎqReiinclude܂B
	 * pXCLASSPATHŎw肳ĂfBNg[gƂݒt@C
	 * ΃pXAt@Ĉ݂w肵܂B
	 * t@Ĉ݂̏ꍇAeXgP[XƓpbP[Wɂ̂Ƃ܂B
	 *
	 * @param path qRei̐ݒt@C̃pX
	 */
	public void include(String path) {
		S2ContainerFactory.include(container_, convertPath(path));
	}

	private String convertPath(String path) {
		if (ResourceUtil.getResourceNoException(path) != null) {
			return path;
		} else {
			String prefix = getClass().getPackage().getName().replace('.', '/');
			return prefix + "/" + path;
		}
	}

	/**
	 * f[^\[X擾܂B
	 *
	 * @return f[^\[X
	 */
	public DataSource getDataSource() {
		if (dataSource_ == null) {
			throw new EmptyRuntimeException("dataSource");
		}
		return dataSource_;
	}

	/**
	 * f[^\[XRlNV擾܂B
	 *
	 * @return f[^\[X擾RlNV
	 */
	public Connection getConnection() {
		if (connection_ != null) {
			return connection_;
		}
		connection_ = DataSourceUtil.getConnection(getDataSource());
		return connection_;
	}

	/**
	 * RlNṼf[^x[X^f[^擾܂B
	 *
	 * @return RlNṼf[^x[X^f[^
	 */
	public DatabaseMetaData getDatabaseMetaData() {
		if (dbMetaData_ != null) {
			return dbMetaData_;
		}
		dbMetaData_ = ConnectionUtil.getMetaData(getConnection());
		return dbMetaData_;
	}

	/**
	 * Excelt@Cǂ݁ADataSet쐬܂B
	 * V[ge[uAsڂJA
	 * sڈȍ~f[^Ƃēǂݍ݂܂B
	 * 
	 * pXCLASSPATHŎw肳ĂfBNg[gƂݒt@C
	 * ΃pXAt@Ĉ݂w肵܂B
	 * t@Ĉ݂̏ꍇAeXgP[XƓpbP[Wɂ̂Ƃ܂B
	 *
	 * @param path Excelt@C̃pX
	 * @return Excelt@C̓e쐬DataSet
	 * @see org.seasar.extension.dataset.impl.XlsReader#read()
	 */
	public DataSet readXls(String path) {
		DataReader reader = new XlsReader(convertPath(path));
		return reader.read();
	}

	/**
	 * DataSet̓eAExcelt@C쐬܂B
	 * V[gɃe[uAsڂɃJA
	 * sڈȍ~Ƀf[^݂܂B
	 *
	 * pXCLASSPATHŎw肳ĂfBNg[gƂݒt@C
	 * ΃pXAt@Ĉ݂w肵܂B
	 * t@Ĉ݂̏ꍇAeXgP[XƓpbP[Wɂ̂Ƃ܂B
	 *
	 * @param path Excelt@C̃pX
	 * @param dataSet Excelt@CɏޓeDataSet
	 * @see org.seasar.extension.dataset.impl.XlsWriter#write(DataSet)
	 */
	public void writeXls(String path, DataSet dataSet) {
		File dir = ResourceUtil.getBuildDir(getClass());
		File file = new File(dir, convertPath(path));
		DataWriter writer = new XlsWriter(FileOutputStreamUtil.create(file));
		writer.write(dataSet);
	}

	/**
	 * DataSetDBɏ݂܂B
	 *
	 * @param dataSet f[^x[XɏޓeDataSet
	 * @see org.seasar.extension.dataset.impl.SqlWriter#write(DataSet)
	 */
	public void writeDb(DataSet dataSet) {
		DataWriter writer = new SqlWriter(getDataSource());
		writer.write(dataSet);
	}

	/**
	 * DB烌R[hǂݍ݁ADataTable쐬܂B
	 *
	 * @param table ǂݍރe[u
	 * @return ǂݍ񂾓e쐬DataTable
	 * @see org.seasar.extension.dataset.impl.SqlTableReader#read()
	 */
	public DataTable readDbByTable(String table) {
		return readDbByTable(table, null);
	}

	/**
	 * DB烌R[hǂݍ݁ADataTable쐬܂B
	 * ǂݍރR[hcondition̏𖞂R[hłB
	 * conditionɂ" WHERE "ZbgĂB
	 *
	 * @param table ǂݍރe[u
	 * @param condition (WHERĚ)
	 * @return ǂݍ񂾓e쐬DataTable
	 * @see org.seasar.extension.dataset.impl.SqlTableReader#read()
	 */
	public DataTable readDbByTable(String table, String condition) {
		SqlTableReader reader = new SqlTableReader(getDataSource());
		reader.setTable(table, condition);
		return reader.read();
	}

	/**
	 * DBSQL̎sʂ擾ADataTable쐬܂B
	 * 쐬DataTablẽe[utableNameɂȂ܂B
	 *
	 * @param sql sSQL
	 * @param tableName 쐬DataTablẽe[u
	 * @return ǂݏoeDataTable
	 * @see org.seasar.extension.dataset.impl.SqlTableReader#read()
	 */
	public DataTable readDbBySql(String sql, String tableName) {
		SqlTableReader reader = new SqlTableReader(getDataSource());
		reader.setSql(sql, tableName);
		return reader.read();
	}

	/**
	 * Excelt@Cǂݍ݁ADBɏ݂܂B
	 * V[ge[uAsڂJA
	 * sڈȍ~f[^Ƃēǂݍ݂܂B
	 *
	 * pXCLASSPATHŎw肳ĂfBNg[gƂݒt@C
	 * ΃pXAt@Ĉ݂w肵܂B
	 * t@Ĉ݂̏ꍇAeXgP[XƓpbP[Wɂ̂Ƃ܂B
	 *
	 * @param path Excelt@C̃pX
	 * @see org.seasar.extension.dataset.impl.XlsReader#read()
	 * @see org.seasar.extension.dataset.impl.SqlWriter#write(DataSet)
	 */
	public void readXlsWriteDb(String path) {
		writeDb(readXls(path));
	}

	/**
	 * Excelt@Cǂݍ݁ADBɏ݂܂B
	 * V[ge[uAsڂJA
	 * sڈȍ~f[^Ƃēǂݍ݂܂B
	 *
	 * Excel̓eDB̃R[hƂŎL[v̂΁A
	 * ̃R[h폜ɏ݂܂B
	 *
	 * pXCLASSPATHŎw肳ĂfBNg[gƂݒt@C
	 * ΃pXAt@Ĉ݂w肵܂B
	 * t@Ĉ݂̏ꍇAeXgP[XƓpbP[Wɂ̂Ƃ܂B
	 *
	 * @param path Excelt@C̃pX
	 * @see org.seasar.extension.dataset.impl.XlsReader#read()
	 * @see org.seasar.extension.dataset.impl.SqlWriter#write(DataSet)
	 */
	public void readXlsReplaceDb(String path) {
		DataSet dataSet = readXls(path);
		deleteDb(dataSet);
		writeDb(dataSet);
	}

	/**
	 * Excelt@Cǂݍ݁ADBɏ݂܂B
	 * V[ge[uAsڂJA
	 * sڈȍ~f[^Ƃēǂݍ݂܂B
	 *
	 * ΏۂƂȂe[ũR[hSč폜ɏ݂܂B
	 *
	 * pXCLASSPATHŎw肳ĂfBNg[gƂݒt@C
	 * ΃pXAt@Ĉ݂w肵܂B
	 * t@Ĉ݂̏ꍇAeXgP[XƓpbP[Wɂ̂Ƃ܂B
	 *
	 * @see org.seasar.extension.dataset.impl.XlsReader#read()
	 * @see org.seasar.extension.dataset.impl.SqlWriter#write(DataSet)
	 */
	public void readXlsAllReplaceDb(String path) {
		DataSet dataSet = readXls(path);
		for (int i = dataSet.getTableSize() - 1; i >= 0; --i) {
			deleteTable(dataSet.getTable(i).getTableName());
		}
		writeDb(dataSet);
	}

	/**
	 * DataSetɑΉDB̃R[hǂݍ݁ADataSet쐬܂B
	 *
	 * @param dataSet ΏDBɑΉDataSet
	 * @return ŐVԂDataSet
	 * @see org.seasar.extension.dataset.impl.SqlReloadReader#read()
	 */
	public DataSet reload(DataSet dataSet) {
		return new SqlReloadReader(getDataSource(), dataSet).read();
	}

	/**
	 * DataTableɑΉDB̃R[hǂݍ݁ADataTable쐬܂B
	 *
	 * @param table ΏDBɑΉDataTable
	 * @return ŐVԂDataTable
	 * @see org.seasar.extension.dataset.impl.SqlReloadTableReader#read()
	 */
	public DataTable reload(DataTable table) {
		return new SqlReloadTableReader(getDataSource(), table).read();
	}

	/**
	 * DataSetɑΉDB̃R[h폜܂B
	 *
	 * @param dataSet ΏDBɑΉDataSet
	 * @see org.seasar.extension.dataset.impl.SqlDeleteTableWriter#write(DataTable)
	 */
	public void deleteDb(DataSet dataSet) {
		SqlDeleteTableWriter writer = new SqlDeleteTableWriter(getDataSource());
		for (int i = dataSet.getTableSize() - 1; i >= 0; --i) {
			writer.write(dataSet.getTable(i));
		}
	}

	/**
	 * DBw肷e[ȗSR[h폜܂B
	 *
	 * @param tableName 폜Ώۂ̃e[u
	 */
	public void deleteTable(String tableName) {
		UpdateHandler handler = new BasicUpdateHandler(getDataSource(),
				"DELETE FROM " + tableName);
		handler.execute(null);
	}

	/**
	 * DataSetmr܂B
	 * J̕я͔rɉe܂B
	 * l͑SBigDecimalƂĔr܂B
	 *
	 * @param expected \l
	 * @param actual ےl
	 */
	public void assertEquals(DataSet expected, DataSet actual) {
		assertEquals(null, expected, actual);
	}

	/**
	 * DataSetmr܂B
	 * J̕я͔rɉe܂B
	 * l͑SBigDecimalƂĔr܂B
	 *
	 * @param message asserts̃bZ[W
	 * @param expected \l
	 * @param actual ےl
	 */
	public void assertEquals(String message, DataSet expected, DataSet actual) {
		message = message == null ? "" : message;
		assertEquals(message + ":TableSize", expected.getTableSize(), actual
				.getTableSize());
		for (int i = 0; i < expected.getTableSize(); ++i) {
			assertEquals(message, expected.getTable(i), actual.getTable(i));
		}
	}

	/**
	 * DataSetmr܂B
	 * J̕я͔rɉe܂B
	 * l͑SBigDecimalƂĔr܂B
	 *
	 * @param expected \l
	 * @param actual ےl
	 */
	public void assertEquals(DataTable expected, DataTable actual) {
		assertEquals(null, expected, actual);
	}

	/**
	 * DataTablemr܂B
	 * J̕я͔rɉe܂B
	 * l͑SBigDecimalƂĔr܂B
	 *
	 * @param message asserts̃bZ[W
	 * @param expected \l
	 * @param actual ےl
	 */
	public void assertEquals(String message, DataTable expected,
			DataTable actual) {

		message = message == null ? "" : message;
		assertEquals(message + ":RowSize", expected.getRowSize(), actual
				.getRowSize());
		for (int i = 0; i < expected.getRowSize(); ++i) {
			DataRow expectedRow = expected.getRow(i);
			DataRow actualRow = actual.getRow(i);

			for (int j = 0; j < expected.getColumnSize(); ++j) {
				String columnName = expected.getColumnName(j);
				Object expectedValue = expectedRow.getValue(columnName);
				ColumnType ct = ColumnTypes.getColumnType(expectedValue);
				Object actualValue = actualRow.getValue(columnName);
				if (!ct.equals(expectedValue, actualValue)) {
					assertEquals(message + ":Row=" + i + ":columnName="
							+ columnName, expectedValue, actualValue);
				}
			}
		}
	}

	/**
	 * IuWFNgDataSetƔr܂B
	 * IuWFNǵABeanAMapABeanListAMapList̂ꂩłȂ
	 * Ȃ܂B
	 *
	 * Bean̏ꍇ̓vpeBAMap̏ꍇ̓L[JƂĔr܂B
	 * J̕я͔rɉe܂B
	 * l͑SBigDecimalƂĔr܂B
	 *
	 * @param expected \l
	 * @param actual ےl
	 */
	public void assertEquals(DataSet expected, Object actual) {
		assertEquals(null, expected, actual);
	}

	/**
	 * IuWFNgDataSetƔr܂B
	 * IuWFNǵABeanAMapABeanListAMapList̂ꂩłȂ
	 * Ȃ܂B
	 *
	 * Bean̏ꍇ̓vpeBAMap̏ꍇ̓L[JƂĔr܂B
	 * J̕я͔rɉe܂B
	 * l͑SBigDecimalƂĔr܂B
	 *
	 * @param message asserts̃bZ[W
	 * @param expected \l
	 * @param actual ےl
	 */
	public void assertEquals(String message, DataSet expected, Object actual) {
		Assert.assertNotNull(expected);
		Assert.assertNotNull(actual);

		Class beanClass = null;
		if (actual instanceof List) {
			List actualList = (List) actual;
			Assert.assertFalse(actualList.isEmpty());
			Object actualItem = actualList.get(0);
			if (actualItem instanceof Map) {
				assertMapListEquals(message, expected, actualList);
			} else {
				assertBeanListEquals(message, expected, actualList);
			}
		} else {
			if (actual instanceof Map) {
				assertMapEquals(message, expected, (Map) actual);
			} else {
				assertBeanEquals(message, expected, actual);
			}
		}
	}

	/**
	 * MapDataSetƔr܂B
	 * Map̃L[JƂĔr܂B
	 * J̕я͔rɉe܂B
	 * l͑SBigDecimalƂĔr܂B
	 *
	 * @param message asserts̃bZ[W
	 * @param expected \l
	 * @param map ےl
	 */
	protected void assertMapEquals(String message, DataSet expected, Map map) {

		MapReader reader = new MapReader(map);
		assertEquals(message, expected, reader.read());
	}

	/**
	 * MapListDataSetƔr܂B
	 * Map̃L[JƂĔr܂B
	 * J̕я͔rɉe܂B
	 * l͑SBigDecimalƂĔr܂B
	 *
	 * @param message asserts̃bZ[W
	 * @param expected \l
	 * @param list ےl
	 */
	protected void assertMapListEquals(String message, DataSet expected,
			List list) {

		MapListReader reader = new MapListReader(list);
		assertEquals(message, expected, reader.read());
	}

	/**
	 * BeanDataSetƔr܂B
	 * BeañvpeBJƂĔr܂B
	 * J̕я͔rɉe܂B
	 * l͑SBigDecimalƂĔr܂B
	 *
	 * @param message asserts̃bZ[W
	 * @param expected \l
	 * @param bean ےl
	 */
	protected void assertBeanEquals(String message, DataSet expected,
			Object bean) {

		BeanReader reader = new BeanReader(bean);
		assertEquals(message, expected, reader.read());
	}

	/**
	 * BeanListDataSetƔr܂B
	 * BeañvpeBJƂĔr܂B
	 * J̕я͔rɉe܂B
	 * l͑SBigDecimalƂĔr܂B
	 *
	 * @param message asserts̃bZ[W
	 * @param expected \l
	 * @param list ےl
	 */
	protected void assertBeanListEquals(String message, DataSet expected,
			List list) {

		BeanListReader reader = new BeanListReader(list);
		assertEquals(message, expected, reader.read());
	}

	/* (Javadoc Ȃ)
	 * @see junit.framework.TestCase#runBare()
	 */
	public void runBare() throws Throwable {
		container_ = new S2ContainerImpl();
		setUp();
		try {
			setUpForEachTestMethod();
			try {
				container_.init();
				try {
					setupDataSource();
					try {
						setUpAfterContainerInit();
						bindFields();
						try {
							runTestTx();
						} finally {
							unbindFields();
						}
						tearDownBeforeContainerDestroy();
					} finally {
						tearDownDataSource();
					}
				} finally {
					container_.destroy();
				}
			} finally {
				tearDownForEachTestMethod();
			}

		} finally {
			tearDown();
		}
	}

	/**
	 * ReiɎsZbgAbv\bhłB
	 * KvȏꍇɃI[o[ChĂB
	 *
	 * @throws Throwable
	 */
	protected void setUpAfterContainerInit() throws Throwable {
	}

	/**
	 * setup() ɎseXg\bhƂ̃ZbgAbv\bhłB
	 * testXxx() Ƃ\bh̏ꍇAsetUpXxx() ƂO
	 * ZbgAbv\bh쐬ĂƁAIɎs܂B
	 *
	 * @throws Throwable
	 */
	protected void setUpForEachTestMethod() throws Throwable {
		invoke("setUp" + getTargetName());
	}

	/**
	 * ReiIOɎsI\bhłB
	 * KvȏꍇɃI[o[ChĂB
	 *
	 * @throws Throwable
	 */
	protected void tearDownBeforeContainerDestroy() throws Throwable {
	}

	/**
	 * tearDown() OɎseXg\bhƂ̏I\bhłB
	 * testXxx() Ƃ\bh̏ꍇAtearDownXxx() ƂO
	 * I\bh쐬ĂƁAIɎs܂B
	 *
	 * @throws Throwable
	 */
	protected void tearDownForEachTestMethod() throws Throwable {
		invoke("tearDown" + getTargetName());
	}

	private String getTargetName() {
		return getName().substring(4);
	}

	private void invoke(String methodName) throws Throwable {
		try {
			Method method = ClassUtil.getMethod(getClass(), methodName, null);
			MethodUtil.invoke(method, this, null);
		} catch (NoSuchMethodRuntimeException ignore) {
		}
	}

	private void bindFields() throws Throwable {
		bindedFields_ = new ArrayList();
		for (Class clazz = getClass(); clazz != S2TestCase.class
				&& clazz != null; clazz = clazz.getSuperclass()) {

			Field[] fields = clazz.getDeclaredFields();
			for (int i = 0; i < fields.length; ++i) {
				bindField(fields[i]);
			}
		}
	}

	private void bindField(Field field) {
		if (isAutoBindable(field)) {
			field.setAccessible(true);
			if (FieldUtil.get(field, this) != null) {
				return;
			}
			String name = normalizeName(field.getName());
			Object component = null;
			if (getContainer().hasComponentDef(name)
					&& field.getType().isAssignableFrom(
							getComponentDef(name).getComponentClass())) {
				component = getComponent(name);
			} else if (getContainer().hasComponentDef(field.getType())) {
				component = getComponent(field.getType());
			}
			if (component != null) {
				FieldUtil.set(field, this, component);
				bindedFields_.add(field);
			}
		}
	}

	private String normalizeName(String name) {
		return StringUtil.replace(name, "_", "");
	}

	private boolean isAutoBindable(Field field) {
		int modifiers = field.getModifiers();
		return !Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers)
				&& !field.getType().isPrimitive();
	}

	private void unbindFields() {
		for (int i = 0; i < bindedFields_.size(); ++i) {
			Field field = (Field) bindedFields_.get(i);
			try {
				field.set(this, null);
			} catch (IllegalArgumentException e) {
				System.err.println(e);
			} catch (IllegalAccessException e) {
				System.err.println(e);
			}
		}
	}

	private void runTestTx() throws Throwable {
		TransactionManager tm = null;
		if (needTransaction()) {
			try {
				tm = (TransactionManager) getComponent(TransactionManager.class);
				tm.begin();
			} catch (Throwable t) {
				System.err.println(t);
			}
		}
		try {
			runTest();
		} finally {
			if (tm != null) {
				tm.rollback();
			}
		}
	}

	private boolean needTransaction() {
		return getName().endsWith("Tx");
	}

	private void setupDataSource() {
		try {
			if (container_.hasComponentDef(DATASOURCE_NAME)) {
				dataSource_ = (DataSource) container_
						.getComponent(DATASOURCE_NAME);
			} else if (container_.hasComponentDef(DataSource.class)) {
				dataSource_ = (DataSource) container_
						.getComponent(DataSource.class);
			}
		} catch (Throwable t) {
			System.err.println(t);
		}
	}

	private void tearDownDataSource() {
		dbMetaData_ = null;
		if (connection_ != null) {
			ConnectionUtil.close(connection_);
			connection_ = null;
		}
		dataSource_ = null;
	}
}