/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.mock.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.seasar.extension.mock.servlet.MockHttpSession;
import org.seasar.framework.util.EmptyEnumeration;
import org.seasar.framework.util.EnumerationAdapter;

public class MockHttpServletRequest
implements HttpServletRequest {
    private static SimpleDateFormat[] DATE_FORMATTERS = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US), new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("yyyy/MM/dd")};
    private ServletContext servletContext_;
    private String servletPath_;
    private String authType_;
    private List cookieList = new ArrayList();
    private Map headers_ = new HashMap();
    private String method_ = "POST";
    private String pathInfo_;
    private String pathTranslated_;
    private String queryString_;
    private MockHttpSession session_;
    private String scheme_ = "http";
    private int serverPort_ = 80;
    private String protocol_ = "HTTP/1.1";
    private String serverName_ = "localhost";
    private Map attributes_ = new HashMap();
    private String characterEncoding_ = "ISO-8859-1";
    private int contentLength_;
    private String contentType_;

    public MockHttpServletRequest(ServletContext servletContext, String servletPath) {
        this.servletContext_ = servletContext;
        this.servletPath_ = servletPath.charAt(0) == '/' ? servletPath : "/" + servletPath;
    }

    public String getAuthType() {
        return this.authType_;
    }

    public void setAuthType(String authType) {
        this.authType_ = authType;
    }

    public Cookie[] getCookies() {
        return this.cookieList.toArray(new Cookie[this.cookieList.size()]);
    }

    public void addCookie(Cookie cookie) {
        this.cookieList.add(cookie);
    }

    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        int i = 0;
        while (i < DATE_FORMATTERS.length) {
            try {
                return DATE_FORMATTERS[i].parse(value).getTime();
            }
            catch (ParseException parseException) {
                ++i;
            }
        }
        throw new IllegalArgumentException(name);
    }

    public String getHeader(String name) {
        List values = this.getHeaderList(name);
        if (values != null) {
            return (String)values.get(0);
        }
        return null;
    }

    public Enumeration getHeaders(String name) {
        List values = this.getHeaderList(name);
        if (values != null) {
            return new EnumerationAdapter(values.iterator());
        }
        return new EmptyEnumeration();
    }

    public Enumeration getHeaderNames() {
        return new EnumerationAdapter(this.headers_.keySet().iterator());
    }

    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public void addHeader(String name, String value) {
        ArrayList<String> values = this.getHeaderList(name);
        if (values == null) {
            values = new ArrayList<String>();
        }
        values.add(value);
        this.headers_.put(name.toLowerCase(), values);
    }

    public void addDateHeader(String name, long value) {
        this.addHeader(name, DATE_FORMATTERS[0].format(new Date(value)));
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, "" + value);
    }

    private List getHeaderList(String name) {
        name = name.toLowerCase();
        return (List)this.headers_.get(name);
    }

    public String getMethod() {
        return this.method_;
    }

    public String getPathInfo() {
        return this.pathInfo_;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo_ = pathInfo;
    }

    public String getPathTranslated() {
        return this.pathTranslated_;
    }

    public void setPathTranslated(String pathTranslated) {
        this.pathTranslated_ = pathTranslated;
    }

    public String getContextPath() {
        return this.servletContext_.getServletContextName();
    }

    public String getQueryString() {
        return this.queryString_;
    }

    public void setQueryString(String queryString) {
        this.queryString_ = queryString;
    }

    public String getRemoteUser() {
        return System.getProperty("user.name");
    }

    public boolean isUserInRole(String arg0) {
        throw new UnsupportedOperationException();
    }

    public Principal getUserPrincipal() {
        throw new UnsupportedOperationException();
    }

    public String getRequestedSessionId() {
        if (this.session_ != null) {
            return this.session_.getId();
        }
        return null;
    }

    public String getRequestURI() {
        String contextPath = this.getContextPath();
        if (contextPath.equals("/")) {
            return this.servletPath_;
        }
        return String.valueOf(contextPath) + this.servletPath_;
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer();
        url.append(this.scheme_);
        url.append("://");
        url.append(this.serverName_);
        if (this.scheme_.equals("http") && this.serverPort_ != 80 || this.scheme_.equals("https") && this.serverPort_ != 443) {
            url.append(':');
            url.append(this.serverPort_);
        }
        url.append(this.getRequestURI());
        return url;
    }

    public String getServletPath() {
        return this.servletPath_;
    }

    public HttpSession getSession(boolean create) {
        if (this.session_ != null) {
            return this.session_;
        }
        if (create) {
            this.session_ = new MockHttpSession(this.servletContext_);
        }
        if (this.session_ != null) {
            this.session_.access();
        }
        return this.session_;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public boolean isRequestedSessionIdValid() {
        if (this.session_ != null) {
            return this.session_.isValid();
        }
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.session_ != null;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public Object getAttribute(String name) {
        return this.attributes_.get(name);
    }

    public Enumeration getAttributeNames() {
        return new EnumerationAdapter(this.attributes_.keySet().iterator());
    }

    public String getCharacterEncoding() {
        return this.characterEncoding_;
    }

    public void setCharacterEncoding(String characterEncoding) throws UnsupportedEncodingException {
        this.characterEncoding_ = characterEncoding;
    }

    public int getContentLength() {
        return this.contentLength_;
    }

    public void setContentLength(int contentLength) {
        this.contentLength_ = contentLength;
    }

    public String getContentType() {
        return this.contentType_;
    }

    public void setContentType(String contentType) {
        this.contentType_ = contentType;
    }

    public ServletInputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getParameter(String arg0) {
        return null;
    }

    public Enumeration getParameterNames() {
        return null;
    }

    public String[] getParameterValues(String arg0) {
        return null;
    }

    public Map getParameterMap() {
        return null;
    }

    public String getProtocol() {
        return this.protocol_;
    }

    public void setProtocol(String protocol) {
        this.protocol_ = protocol;
    }

    public String getScheme() {
        return this.scheme_;
    }

    public void setScheme(String scheme) {
        this.scheme_ = scheme;
    }

    public String getServerName() {
        return this.serverName_;
    }

    public void setServerName(String serverName) {
        this.serverName_ = serverName;
    }

    public int getServerPort() {
        return this.serverPort_;
    }

    public void setServerPort(int serverPort) {
        this.serverPort_ = serverPort;
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public void setAttribute(String arg0, Object arg1) {
    }

    public void removeAttribute(String arg0) {
    }

    public Locale getLocale() {
        return null;
    }

    public Enumeration getLocales() {
        return null;
    }

    public boolean isSecure() {
        return false;
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        return null;
    }

    public String getRealPath(String arg0) {
        return null;
    }
}

