/*
 * 쐬F 2004/09/03
 */
package org.seasar.tapestry.pageinjection.impl;


import java.util.List;

import org.seasar.extension.unit.S2TestCase;
import org.seasar.tapestry.pageinjection.Injection;

/**
 * @author maruo_syunsuke
 */
public class UserPageInjectionTest extends S2TestCase {

	/**
	 * Constructor for TopInjectionTest.
	 * @param arg0
	 */
	public UserPageInjectionTest(String arg0) {
		super(arg0);
	}
	/**
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		include("UserPageInjectionTest.dicon");
	}
	public void testInjection() {
		T3 t3 = new T3();
		
		assertNull("DIO1", t3.getList1());
		assertNull("DIO2", t3.getList2());
		assertNull("DIO3", t3.getList3());
		
		Injection injection = null ;
		try {
			injection = new ExtentionClassInjection(getContainer(), 
													T1.class.getName());
		} catch (ClassNotFoundException e) {
			fail();
		}
		injection.invoke(t3);
		List lst = (List)getComponent(List.class);
		
		assertNull("DI1", t3.getList1());
		assertEquals("DI2", lst, t3.getList2());
		assertEquals("DI3", lst, t3.getList3());
	}
	public void testAllInjection() {
		T3 t3 = new T3();
		
		assertNull("DIO1", t3.getList1());
		assertNull("DIO2", t3.getList2());
		assertNull("DIO3", t3.getList3());
		
		Injection injection = new ExtentionClassInjection(getContainer());
		injection.invoke(t3);
		List lst = (List)getComponent(List.class);
		
		assertEquals("DI1", lst, t3.getList1());
		assertEquals("DI2", lst, t3.getList2());
		assertEquals("DI3", lst, t3.getList3());
	}
}

