/*
 * 쐬F 2004/08/19
 */
package org.seasar.tapestry.engine;

import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.html.BasePage;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.tapestry.pageinjection.Injection;

/**
 * @author maruo_syunsuke
 */
public class S2PageLoader extends CopyOfPageLoader {
	/**
	 * @param cycle
	 */
	public S2PageLoader(IRequestCycle cycle) {
		super(cycle);
	}

	public String getDefaultPage() {
		return BasePage.class.getName();
	}

	/**
	 * @see org.seasar.tapestry.CopyOfPageLoader#getPageComponent(java.lang.Class)
	 */
	public IPage getPageComponent(Class pageClass)
			throws InstantiationException, IllegalAccessException {
		IPage result = null;
		result = (IPage) pageClass.newInstance();
		S2Container container = SingletonS2ContainerFactory.getContainer();
		if (container.hasComponentDef(Injection.class)) {
			Injection injection = (Injection) container
					.getComponent(Injection.class);
			injection.invoke(result);
		}
		return result;
	}
}