package org.seasar.tapestry;

import java.util.HashSet;
import java.util.Set;

import ognl.OgnlRuntime;

import org.apache.tapestry.engine.BaseEngine;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.IPageSource;
import org.apache.tapestry.engine.IPropertySource;
import org.apache.tapestry.request.RequestContext;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.StringUtil;
import org.seasar.tapestry.engine.S2PageSource;
import org.seasar.tapestry.ognl.GlobalProxyPropertyAccessor;
import org.seasar.tapestry.ognl.ListenersPropertyAccessor;
import org.seasar.tapestry.ognl.binder.Binder;
import org.seasar.tapestry.ognl.binder.impl.GlobalProxy;
import org.seasar.tapestry.pageinjection.Injection;
import org.seasar.tapestry.pageinjection.impl.ExtentionClassInjection;

/**
 * S2Tapestry̎sGW
 * 
 * @author higa
 * @object-type UserObject
 */
public class S2Engine extends BaseEngine {
	public static final String CONFIG_PATH_KEY = "configPath";

//	private static final Log LOG = LogFactory.getLog(S2Engine.class);

	private Set initializingServiceFlag_ = new HashSet();

	static {
		OgnlRuntime.setPropertyAccessor(GlobalProxy.class, new GlobalProxyPropertyAccessor());
        OgnlRuntime.setPropertyAccessor(Binder.class, new ListenersPropertyAccessor());
	}

	public S2Engine() {
		super();

		IPropertySource source = this.getPropertySource();
		if (source != null) {
			String configPath = source.getPropertyValue(CONFIG_PATH_KEY);
			if (!StringUtil.isEmpty(configPath)) {
				SingletonS2ContainerFactory.setConfigPath(configPath);
			}
		}
		SingletonS2ContainerFactory.init();
	}

	protected Object createGlobal(RequestContext context) {
		Object global = super.createGlobal(context);
		return new GlobalProxy(global);
	}

	protected IPageSource createPageSource(RequestContext context) {
		IPageSource pageSource = new S2PageSource(this);
		return pageSource;
	}

	public boolean isAlreadyDI(String name) {
		return this.initializingServiceFlag_.contains(name);
	}

	private void checkFlag(String name) {
		this.initializingServiceFlag_.add(name);
	}

	public IEngineService getService(String name) {
		IEngineService ret = super.getService(name);
		if (isAlreadyDI(name) == false) {
			S2Container container = SingletonS2ContainerFactory.getContainer();
			Injection injection = new ExtentionClassInjection(container);	
			//			Injection injection = (Injection)container.getComponent(Injection.class);
			if( injection != null ) injection.invoke(ret);
			checkFlag(name);
		}
		return ret;
	}
}