/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.axis.client;

import java.lang.reflect.Method;
import java.net.URL;
import javax.xml.namespace.QName;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.util.MethodUtil;

public class DynamicInvocationInterceptor
extends AbstractInterceptor {
    private final Service service;
    private final URL url;

    public DynamicInvocationInterceptor(Service service, URL url) {
        this.service = service;
        this.url = url;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (!MethodUtil.isAbstract((Method)method)) {
            return invocation.proceed();
        }
        Call call = (Call)this.service.createCall();
        call.setTargetEndpointAddress(this.url);
        call.setOperationName(new QName("http://soapinterop.org/", method.getName()));
        call.setReturnClass(method.getReturnType());
        return call.invoke(invocation.getArguments());
    }
}

