/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.components.net.CommonsHTTPClientProperties;
import org.apache.axis.components.net.CommonsHTTPClientPropertiesFactory;
import org.apache.axis.components.net.TransportClientProperties;
import org.apache.axis.components.net.TransportClientPropertiesFactory;
import org.apache.axis.encoding.Base64;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.Messages;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;

public class CommonsHTTPSender
extends BasicHandler {
    protected static Log log = LogFactory.getLog((class$org$apache$axis$transport$http$CommonsHTTPSender == null ? (class$org$apache$axis$transport$http$CommonsHTTPSender = CommonsHTTPSender.class$("org.apache.axis.transport.http.CommonsHTTPSender")) : class$org$apache$axis$transport$http$CommonsHTTPSender).getName());
    private HttpConnectionManager connectionManager;
    private CommonsHTTPClientProperties clientProperties;
    static /* synthetic */ Class class$org$apache$axis$transport$http$CommonsHTTPSender;

    public CommonsHTTPSender() {
        MultiThreadedHttpConnectionManager cm = new MultiThreadedHttpConnectionManager();
        this.clientProperties = CommonsHTTPClientPropertiesFactory.create();
        cm.setMaxConnectionsPerHost(this.clientProperties.getMaximumConnectionsPerHost());
        cm.setMaxTotalConnections(this.clientProperties.getMaximumTotalConnections());
        this.connectionManager = cm;
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        PostMethod method = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("enter00", "CommonsHTTPSender::invoke"));
        }
        try {
            URL targetURL = new URL(msgContext.getStrProp("transport.url"));
            HttpClient httpClient = new HttpClient(this.connectionManager);
            httpClient.setHttpConnectionFactoryTimeout((long)this.clientProperties.getConnectionPoolTimeout());
            HostConfiguration hostConfiguration = this.getHostConfiguration(httpClient, targetURL);
            httpClient.setHostConfiguration(hostConfiguration);
            String webMethod = null;
            boolean posting = true;
            if (msgContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS && (webMethod = msgContext.getStrProp("soap12.webmethod")) != null) {
                posting = webMethod.equals("POST");
            }
            Message reqMessage = msgContext.getRequestMessage();
            if (posting) {
                method = new PostMethod(targetURL.toString());
                this.addContextInfo((HttpMethodBase)method, httpClient, msgContext, targetURL);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                reqMessage.writeTo(baos);
                method.setRequestBody((InputStream)new ByteArrayInputStream(baos.toByteArray()));
                method.setUseExpectHeader(false);
            } else {
                method = new GetMethod(targetURL.toString());
                this.addContextInfo((HttpMethodBase)method, httpClient, msgContext, targetURL);
            }
            if (msgContext.getMaintainSession()) {
                int index;
                HttpState state = httpClient.getState();
                state.setCookiePolicy(0);
                String host = hostConfiguration.getHost();
                String path = targetURL.getPath();
                boolean secure = hostConfiguration.getProtocol().isSecure();
                String ck1 = (String)msgContext.getProperty("Cookie");
                String ck2 = (String)msgContext.getProperty("Cookie2");
                if (ck1 != null) {
                    index = ck1.indexOf(61);
                    state.addCookie(new Cookie(host, ck1.substring(0, index), ck1.substring(index + 1), path, null, secure));
                }
                if (ck2 != null) {
                    index = ck2.indexOf(61);
                    state.addCookie(new Cookie(host, ck2.substring(0, index), ck2.substring(index + 1), path, null, secure));
                }
                httpClient.setState(state);
            }
            int returnCode = httpClient.executeMethod((HttpMethod)method);
            String contentType = null;
            String contentLocation = null;
            String contentLength = null;
            if (method.getResponseHeader("Content-Type") != null) {
                contentType = method.getResponseHeader("Content-Type").getValue();
            }
            if (method.getResponseHeader("Content-Location") != null) {
                contentLocation = method.getResponseHeader("Content-Location").getValue();
            }
            if (method.getResponseHeader("Content-Length") != null) {
                contentLength = method.getResponseHeader("Content-Length").getValue();
            }
            String string = contentType = null == contentType ? null : contentType.trim();
            if (!(returnCode > 199 && returnCode < 300 || msgContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS || contentType != null && !contentType.equals("text/html") && returnCode > 499 && returnCode < 600)) {
                String statusMessage = method.getStatusText();
                AxisFault fault = new AxisFault("HTTP", "(" + returnCode + ")" + statusMessage, null, null);
                fault.setFaultDetailString(Messages.getMessage("return01", "" + returnCode, method.getResponseBodyAsString()));
                throw fault;
            }
            Message outMsg = new Message(method.getResponseBodyAsStream(), false, contentType, contentLocation);
            Header[] responseHeaders = method.getResponseHeaders();
            MimeHeaders responseMimeHeaders = outMsg.getMimeHeaders();
            for (int i = 0; i < responseHeaders.length; ++i) {
                Header responseHeader = responseHeaders[i];
                responseMimeHeaders.addHeader(responseHeader.getName(), responseHeader.getValue());
            }
            outMsg.setMessageType("response");
            msgContext.setResponseMessage(outMsg);
            if (log.isDebugEnabled()) {
                if (null == contentLength) {
                    log.debug((Object)("\n" + Messages.getMessage("no00", "Content-Length")));
                }
                log.debug((Object)("\n" + Messages.getMessage("xmlRecd00")));
                log.debug((Object)"-----------------------------------------------");
                log.debug((Object)outMsg.getSOAPPartAsString());
            }
            if (msgContext.getMaintainSession()) {
                Header[] headers = method.getResponseHeaders();
                for (int i = 0; i < headers.length; ++i) {
                    if (headers[i].getName().equalsIgnoreCase("Set-Cookie")) {
                        msgContext.setProperty("Cookie", this.cleanupCookie(headers[i].getValue()));
                        continue;
                    }
                    if (!headers[i].getName().equalsIgnoreCase("Set-Cookie2")) continue;
                    msgContext.setProperty("Cookie2", this.cleanupCookie(headers[i].getValue()));
                }
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
            throw AxisFault.makeFault(e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("exit00", "CommonsHTTPSender::invoke"));
        }
    }

    private String cleanupCookie(String cookie) {
        int index = (cookie = cookie.trim()).indexOf(59);
        if (index != -1) {
            cookie = cookie.substring(0, index);
        }
        return cookie;
    }

    private HostConfiguration getHostConfiguration(HttpClient client, URL targetURL) {
        TransportClientProperties tcp = TransportClientPropertiesFactory.create(targetURL.getProtocol());
        int port = targetURL.getPort();
        boolean hostInNonProxyList = this.isHostInNonProxyList(targetURL.getHost(), tcp.getNonProxyHosts());
        HostConfiguration config = new HostConfiguration();
        if (port == -1) {
            port = 80;
        }
        if (tcp.getProxyHost().length() == 0 || tcp.getProxyPort().length() == 0 || hostInNonProxyList) {
            config.setHost(targetURL.getHost(), port, targetURL.getProtocol());
        } else {
            if (tcp.getProxyUser().length() != 0) {
                UsernamePasswordCredentials proxyCred = new UsernamePasswordCredentials(tcp.getProxyUser(), tcp.getProxyPassword());
                client.getState().setProxyCredentials(null, null, (Credentials)proxyCred);
            }
            int proxyPort = new Integer(tcp.getProxyPort());
            config.setProxy(tcp.getProxyHost(), proxyPort);
        }
        return config;
    }

    private void addContextInfo(HttpMethodBase method, HttpClient httpClient, MessageContext msgContext, URL tmpURL) throws Exception {
        Hashtable userHeaderTable;
        MimeHeaders mimeHeaders;
        Message msg;
        String action;
        if (msgContext.getTimeout() != 0) {
            httpClient.setTimeout(msgContext.getTimeout());
            httpClient.setConnectionTimeout(msgContext.getTimeout());
        }
        String string = action = msgContext.useSOAPAction() ? msgContext.getSOAPActionURI() : "";
        if (action == null) {
            action = "";
        }
        if ((msg = msgContext.getRequestMessage()) != null) {
            method.setRequestHeader(new Header("Content-Type", msg.getContentType(msgContext.getSOAPConstants())));
        }
        method.setRequestHeader(new Header("SOAPAction", "\"" + action + "\""));
        String userID = msgContext.getUsername();
        String passwd = msgContext.getPassword();
        if (userID == null && tmpURL.getUserInfo() != null) {
            String info = tmpURL.getUserInfo();
            int sep = info.indexOf(58);
            if (sep >= 0 && sep + 1 < info.length()) {
                userID = info.substring(0, sep);
                passwd = info.substring(sep + 1);
            } else {
                userID = info;
            }
        }
        if (userID != null) {
            UsernamePasswordCredentials cred = new UsernamePasswordCredentials(userID, passwd);
            httpClient.getState().setCredentials(null, null, (Credentials)cred);
            StringBuffer tmpBuf = new StringBuffer();
            tmpBuf.append(userID).append(":").append(passwd == null ? "" : passwd);
            method.addRequestHeader("Authorization", "Basic " + Base64.encode(tmpBuf.toString().getBytes()));
        }
        if ((mimeHeaders = msg.getMimeHeaders()) != null) {
            Iterator i = mimeHeaders.getAllHeaders();
            while (i.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)i.next();
                method.addRequestHeader(mimeHeader.getName(), mimeHeader.getValue());
            }
        }
        if ((userHeaderTable = (Hashtable)msgContext.getProperty("HTTP-Request-Headers")) != null) {
            Iterator e = userHeaderTable.entrySet().iterator();
            while (e.hasNext()) {
                Map.Entry me = e.next();
                Object keyObj = me.getKey();
                if (null == keyObj) continue;
                String key = keyObj.toString().trim();
                String value = me.getValue().toString().trim();
                method.addRequestHeader(key, value);
            }
        }
    }

    protected boolean isHostInNonProxyList(String host, String nonProxyHosts) {
        if (nonProxyHosts == null || host == null) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(nonProxyHosts, "|\"");
        while (tokenizer.hasMoreTokens()) {
            String pattern = tokenizer.nextToken();
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("match00", new String[]{"HTTPSender", host, pattern}));
            }
            if (!CommonsHTTPSender.match(pattern, host, false)) continue;
            return true;
        }
        return false;
    }

    protected static boolean match(String pattern, String str, boolean isCaseSensitive) {
        char ch;
        int i;
        char[] patArr = pattern.toCharArray();
        char[] strArr = str.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        for (i = 0; i < patArr.length; ++i) {
            if (patArr[i] != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (i = 0; i <= patIdxEnd; ++i) {
                char ch2 = patArr[i];
                if (isCaseSensitive && ch2 != strArr[i]) {
                    return false;
                }
                if (isCaseSensitive || Character.toUpperCase(ch2) == Character.toUpperCase(strArr[i])) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (isCaseSensitive && ch != strArr[strIdxStart]) {
                return false;
            }
            if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart])) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (isCaseSensitive && ch != strArr[strIdxEnd]) {
                return false;
            }
            if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxEnd])) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i2 = patIdxStart + 1; i2 <= patIdxEnd; ++i2) {
                if (patArr[i2] != '*') continue;
                patIdxTmp = i2;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block8: for (int i3 = 0; i3 <= strLength - patLength; ++i3) {
                for (int j = 0; j < patLength; ++j) {
                    ch = patArr[patIdxStart + j + 1];
                    if (isCaseSensitive && ch != strArr[strIdxStart + i3 + j] || !isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart + i3 + j])) continue block8;
                }
                foundIdx = strIdxStart + i3;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (i = patIdxStart; i <= patIdxEnd; ++i) {
            if (patArr[i] == '*') continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

