package org.seasar.flex;

import java.lang.reflect.Method;
import java.util.List;

import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

import flashgateway.action.ActionContext;
import flashgateway.adapter.java.JavaAdapter;

/**
 * @author higa
 *  
 */
public class S2Adapter extends JavaAdapter {

	private static final String FLEX10_ASTRANSLATOR = "flex.remote.translator.ASTranslator";

	private static final String FLEX15_ASTRANSLATOR = "flashgateway.translator.ASTranslator";

	private static final String FROM_ACTIONSCRIPT = "fromActionScript";

	private static final String TO_ACTIONSCRIPT = "toActionScript";

	private Method fromActionScript_;

	private Method toActionScript_;

	public S2Adapter() {
		Class clazz = findASTranslatorClass();
		setupMethod(clazz);
	}

	protected Class findASTranslatorClass() {
		try {
			return Class.forName(FLEX15_ASTRANSLATOR);
		} catch (ClassNotFoundException ignore) {
			try {
				return Class.forName(FLEX10_ASTRANSLATOR);
			} catch (ClassNotFoundException ex) {
				throw new RuntimeException("ASTranslator not found", ex);
			}
		}
	}

	protected void setupMethod(Class clazz) {
		try {
			fromActionScript_ = clazz.getMethod(FROM_ACTIONSCRIPT,
					new Class[] { Object.class });
		} catch (NoSuchMethodException ex) {
			throw new RuntimeException(FROM_ACTIONSCRIPT + " not found", ex);
		}
		try {
			toActionScript_ = clazz.getMethod(TO_ACTIONSCRIPT,
					new Class[] { Object.class });
		} catch (NoSuchMethodException ex) {
			throw new RuntimeException(TO_ACTIONSCRIPT + " not found", ex);
		}
	}

	/**
	 * @see flashgateway.adapter.ServiceAdapter#invokeFunction(flashgateway.action.ActionContext,
	 *      java.lang.String, java.lang.String, java.util.List)
	 */
	public Object invokeFunction(ActionContext ctx, String name,
			String methodName, List argList) throws Throwable {

		S2Container container = SingletonS2ContainerFactory.getContainer();
		Object component = container.getComponent(name);
		BeanDesc beanDesc = BeanDescFactory.getBeanDesc(component.getClass());
		Object ret = beanDesc.invoke(component, methodName,
				convertArgList(argList));
		return toActionScript(ret);
	}

	protected Object[] convertArgList(List argList) throws Throwable {
		Object[] args = new Object[argList.size()];
		for (int i = 0; i < args.length; ++i) {
			args[i] = fromActionScript(argList.get(i));
		}
		return args;
	}

	protected Object fromActionScript(Object obj) throws Throwable {
		return fromActionScript_.invoke(null, new Object[] { obj });
	}

	protected Object toActionScript(Object obj) throws Throwable {
		return toActionScript_.invoke(null, new Object[] { obj });
	}

	/**
	 * @see flashgateway.adapter.ServiceAdapter#supportsService(flashgateway.action.ActionContext,
	 *      java.lang.String, java.lang.String, java.util.List,
	 *      java.lang.String)
	 */
	public boolean supportsService(ActionContext ctx, String name,
			String methodName, List argList, String arg4) throws Exception {

		S2Container container = SingletonS2ContainerFactory.getContainer();
		return container.hasComponentDef(name);
	}
}