/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.assembler;

import java.lang.reflect.Constructor;
import org.seasar.framework.aop.proxy.AopProxy;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.IllegalConstructorRuntimeException;
import org.seasar.framework.container.assembler.AbstractConstructorAssembler;
import org.seasar.framework.container.util.AutoBindingUtil;
import org.seasar.framework.util.ConstructorUtil;

public final class AutoConstructorAssembler
extends AbstractConstructorAssembler {
    public AutoConstructorAssembler(ComponentDef componentDef) {
        super(componentDef);
    }

    public Object assemble() throws IllegalConstructorRuntimeException {
        Constructor constructor = this.getSuitableConstructor();
        if (constructor == null) {
            return this.assembleDefault();
        }
        Object[] args = this.getArgs(constructor.getParameterTypes());
        if (this.getComponentDef().getAspectDefSize() > 0) {
            AopProxy aopProxy = this.createAopProxy();
            return aopProxy.create(constructor.getParameterTypes(), args);
        }
        return ConstructorUtil.newInstance(constructor, args);
    }

    private Constructor getSuitableConstructor() {
        int argSize = -1;
        Constructor<?> constructor = null;
        Constructor<?>[] constructors = this.getComponentDef().getComponentClass().getConstructors();
        int i = 0;
        while (i < constructors.length) {
            int tempArgSize = constructors[i].getParameterTypes().length;
            if (tempArgSize == 0) {
                return null;
            }
            if (tempArgSize > argSize && AutoBindingUtil.isSuitable(constructors[i].getParameterTypes())) {
                constructor = constructors[i];
                argSize = tempArgSize;
            }
            ++i;
        }
        return constructor;
    }
}

