/*
 * 쐬F 2004/08/20
 */
package org.seasar.tapestry;

import org.apache.tapestry.IEngine;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.pageload.PageLoader;
import org.apache.tapestry.pageload.PageSource;

/**
 * @author maruo_syunsuke
 */
public class S2PageSource extends PageSource {
	/**
	 * @param engine
	 */
	public S2PageSource(IEngine engine) {
		super(engine);
	}

	protected S2PageLoader createPageLoader(IRequestCycle cycle) {
		return new S2PageLoader(cycle);
	}

	protected PageLoader getPageLoader(IRequestCycle cycle) {
		PageLoader result = (PageLoader) cycle.getEngine().getPool().retrieve(
				PageLoader.class.getName());

		if (result == null)
			result = createPageLoader(cycle);

		return result;
	}
}