package org.seasar.tapestry;

import java.util.HashSet;
import java.util.Set;

import ognl.OgnlRuntime;

import org.apache.tapestry.engine.BaseEngine;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.IPageSource;
import org.apache.tapestry.request.RequestContext;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.tapestry.global.GlobalProxy;
import org.seasar.tapestry.global.GlobalProxyPropertyAccessor;
import org.seasar.tapestry.pageinjection.impl.ExtentionClassInjection;

/**
 * @author higa
 *  
 */
public class S2Engine extends BaseEngine {
	private Set set = new HashSet();
	
	static {
		OgnlRuntime.setPropertyAccessor(GlobalProxy.class,
				new GlobalProxyPropertyAccessor());
	}

	protected Object createGlobal(RequestContext context) {
		Object global = super.createGlobal(context);
		return new GlobalProxy(global);
	}

	protected IPageSource createPageSource(RequestContext context) {
		IPageSource pageSource = new S2PageSource(this);
		return pageSource;
	}
	
	public IEngineService getService(String name) {
		IEngineService ret ;
		ret = super.getService(name);
		if(set.add(name)) {
			S2Container container = SingletonS2ContainerFactory.getContainer();
			ExtentionClassInjection injection = new ExtentionClassInjection(container);
			injection.injection(ret);
		}
		return ret ;
	}
}