/*
 * 쐬F 2004/09/06
 */
package org.seasar.tapestry;

import javax.servlet.ServletException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.ApplicationServlet;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.request.RequestContext;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

/**
 * @author maruo_syunsuke
 */
public class S2ApplicationServlet extends ApplicationServlet {
	private static final Log LOG = LogFactory
			.getLog(S2ApplicationServlet.class);

	protected IEngine createEngine(RequestContext context)
			throws ServletException {
		IEngine result;
		S2Container container = SingletonS2ContainerFactory.getContainer();
		if (container.hasComponentDef(IEngine.class)) {
			result = (IEngine) container.getComponent(IEngine.class);
		} else {
			String className = getEngineClassName();
			Class engineClass = getResourceResolver().findClass(className);

			try {
				result = (IEngine) engineClass.newInstance();
			} catch (Exception ex) {
				throw new ServletException(ex);
			}
		}
		if( LOG.isDebugEnabled() && result != null ) {
			LOG.debug( "Engine : " + result.getClass().getName());
		}
		return result;
	}
}